package hiro.yoshioka.sql.engine;

import hiro.yoshioka.sql.DataBaseFactory;
import hiro.yoshioka.sql.IConnectSQL;
import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.SqlBasicListener;
import hiro.yoshioka.sql.SqlTransactionListener;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.ConnectionSettingBean;
import hiro.yoshioka.sql.params.IConnectionPropertiesChangeListener;
import hiro.yoshioka.sql.params.PropetiesChangeType;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.util.SQLHistroyManager;
import hiro.yoshioka.sql.util.SQLUtil;
import hiro.yoshioka.util.FileUtil;
import hiro.yoshioka.util.ref.ReferenceTracker;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.ui.texteditor.IUpdate;

public class SQLServerThread extends Thread implements IRequestListener {
	protected Log fLogger = LogFactory.getLog(getClass());
	private static final SQLServerThread fSingle = new SQLServerThread(
			"SQLServer");

	private RequestQueue requestQueue;

	private boolean fExit;

	private boolean fInitialized;

	private File configFileDir;
	private File connectionSetFile;
	private ConnectionSettingBean fConnectionSettingBean;

	Thread fThread;

	private Map<ConnectionProperties, ITransactionSQL> sqlMap = new LinkedHashMap<ConnectionProperties, ITransactionSQL>();

	private List<IConnectionPropertiesChangeListener> fConPropeteisUpdateList;
	private List<SqlBasicListener> fConnectionList = new ArrayList<SqlBasicListener>();
	private List<SqlTransactionListener> fTransactionList = new ArrayList<SqlTransactionListener>();

	public static SQLServerThread getSQLServer() {
		return fSingle;
	}

	private SQLServerThread(String name) {
		super(name);
		SQLHistroyManager.getInstance();
	}

	public boolean isClosable(ConnectionProperties properties) {
		ITransactionSQL sql = getTransactionSQL(properties);
		if (sql == null) {
			fLogger.info("sql=null ! properties:" + properties);
			return false;
		}
		return sql.canDoOperation(SQLOperationType.CLOSE);
	}

	public ITransactionSQL getTransactionSQL(DBRoot root) {
		if (fLogger.isInfoEnabled()) {
			for (ConnectionProperties key : sqlMap.keySet()) {
				if (key.getDBRoot() == root) {
					return getTransactionSQL(key);
				}
			}
		}
		return null;
	}

	public ITransactionSQL getTransactionSQL(ConnectionProperties properties) {
		if (fLogger.isInfoEnabled()) {
			fLogger.info("input key:" + properties.getCreated() + " DISP:"
					+ properties.getDisplayString());
			for (ConnectionProperties key : sqlMap.keySet()) {
				fLogger.info("now contain key:" + key.getCreated() + " DISP:"
						+ key.getDisplayString());
			}
		}
		return sqlMap.get(properties);
	}

	public void addConnectionPropertiesChangedListener(
			IConnectionPropertiesChangeListener listener) {
		if (fConPropeteisUpdateList == null) {
			fConPropeteisUpdateList = new ArrayList<IConnectionPropertiesChangeListener>();
			;
		}
		fConPropeteisUpdateList.add(listener);
	}

	public void addConnectionListner(SqlBasicListener listener) {
		fConnectionList.add(listener);
		for (ITransactionSQL sql : sqlMap.values()) {
			sql.addConnectionListner(listener);
		}
	}

	public void removeConnectionListener(SqlBasicListener listener) {
		fConnectionList.remove(listener);
		for (ITransactionSQL sql : sqlMap.values()) {
			sql.removeConnetionListener(listener);
		}
	}

	public void addTracsactionListner(SqlTransactionListener listener) {
		fTransactionList.add(listener);
		for (ITransactionSQL sql : sqlMap.values()) {
			sql.addTracsactionListner(listener);
		}
	}

	public void removeTracsactionListner(SqlTransactionListener listener) {
		fTransactionList.remove(listener);
		for (ITransactionSQL sql : sqlMap.values()) {
			sql.removeTracsactionListner(listener);
		}
	}

	public boolean wasInitialized() {
		fLogger.info("fInitialized:" + fInitialized);
		return fInitialized;
	}

	public static int putRequest(Request request) {
		getSQLServer().requestQueue.putRequest(request);
		return getSQLServer().requestQueue.getSize();
	}

	public File getConfigFileDir() {
		return configFileDir;
	}

	public boolean init(File configFileDir) {
		this.configFileDir = configFileDir;
		if (!this.configFileDir.exists()) {
			if (!this.configFileDir.mkdir()) {
				return false;
			}
		}
		this.connectionSetFile = new File(configFileDir, "connections.def");
		if (fThread != null) {
			dispose();
		}
		loadConnectionProperties();

		fExit = false;
		this.requestQueue = new RequestQueue();

		fThread = new Thread(this);
		fThread.setName("I'm Daemon For acceptting SQL Request ");
		fThread.setDaemon(true);
		fThread.start();
		ReferenceTracker.weakTrace(fThread);
		fInitialized = true;

		return true;
	}

	private void loadConnectionProperties() {
		ConnectionSettingBean load = null;
		try {
			load = (ConnectionSettingBean) SQLUtil
					.readObject(connectionSetFile);
		} catch (Exception e) {
			e.printStackTrace();
		}
		System.out.println("load result=" + (load != null));
		if (load == null) {
			fConnectionSettingBean = new ConnectionSettingBean();
			sqlMap = new LinkedHashMap<ConnectionProperties, ITransactionSQL>();
		} else {
			fConnectionSettingBean = load;
		}
	}

	public boolean changeConnectionProperties(
			PropetiesChangeType propetiesChangeType,
			Collection<ConnectionProperties> newProperties) throws IOException {
		boolean ret = false;
		if (fConnectionSettingBean.changeConnectionProperties(newProperties)) {
			ret = saveConnectionProperties();
		}
		updateConnection(propetiesChangeType);
		return ret;
	}

	public ConnectionSettingBean getConnectionSettingBean() {
		return fConnectionSettingBean;
	}

	public boolean saveConnectionProperties() throws IOException {
		System.out.println("save :: " + fConnectionSettingBean);
		return FileUtil.save(connectionSetFile, fConnectionSettingBean);
	}

	public void dispose() {
		fExit = true;
		try {
			saveConnectionProperties();
		} catch (IOException e1) {
		}
		fLogger.info("dispose... ");
		if (fInitialized) {
			requestQueue.putRequest(new NoMoreRequest(SQLOperationType.TEST));
		}
		fLogger.info("canncel");
		try {
			SQLHistroyManager.getInstance().save();
		} catch (Exception e) {
			e.printStackTrace();
		}
		for (ITransactionSQL sql : sqlMap.values()) {
			if (sql != null && sql instanceof IConnectSQL) {
				try {
					sql.cansel();
				} catch (SQLException e) {
				}
				try {
					IConnectSQL isql = (IConnectSQL) sql;
					isql.close();
				} catch (SQLException e) {
				}
			}
		}
	}

	public void run() {
		for (int i = 0; i < 1000000; i++) {
			Request request = requestQueue.getRequest();
			request.addListener(this);
			if (fExit) {
				fLogger.info(Thread.currentThread().getName()
						+ "Exit... and sutemasukara- handles  " + request);
				break;
			}
			fLogger.info(Thread.currentThread().getName() + " handles  "
					+ request);
			if (SQLOperationType.CONNECT == request.operation) {
				ITransactionSQL sql = sqlMap.get(request
						.getConnectionProperties());
				if (sql == null) {
					sql = DataBaseFactory.createSQL(request
							.getConnectionProperties());
					sqlMap.put(request.getConnectionProperties(), sql);
				}
				if (sql != null) {
					if (!request.execute()) {
						if (request.e instanceof SQLException) {
							SQLException se = (SQLException) request.e;
							// if (fSQL instanceof HSQL) {
							// if
							// (se.getMessage().equals("socket creation error")
							// || se.getErrorCode() == -80) {
							// // if (!HSQLAction.isRunning()) {
							// // Application
							// // .openDialog(
							// // "Info",
							// // "Please push HSQL Server button at tool bar",
							// // MessageDialog.INFORMATION);
							// // }
							// }
							// }
						}
					}
				}
			} else {
				request.start();
			}
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
			}
		}
	}

	public void removeConnectionPropertiesChangedListener(
			IConnectionPropertiesChangeListener listener) {
		if (fConPropeteisUpdateList != null) {
			fConPropeteisUpdateList.remove(listener);
		}
	}

	public void updateConnection(PropetiesChangeType type) {
		if (fConPropeteisUpdateList != null) {
			for (IConnectionPropertiesChangeListener obj : fConPropeteisUpdateList) {
				if (obj != null) {
					try {
						obj.changed(type, fConnectionSettingBean);
					} catch (Exception e) {
					}
				}
			}
		}
	}

	class NoMoreRequest extends Request {
		public NoMoreRequest(SQLOperationType operation) {
			super(operation);
		}
	}

	public void called_pre(Request request, SQLOperationType operation) {
	}

	public void called_done(Request request, SQLOperationType operation,
			ConnectionProperties properteis, Object o) {
		if (!request.hasException() && request instanceof TransactionRequest) {
			SQLHistroyManager.getInstance().addStatement(
					(TransactionRequest) request);
		}
	}

	public void begtinTask(String taskName, int row) {
	}

	public void subTask(String subTaskName) {
	}

	public void worked(int i) {
	}

	public Collection<ConnectionProperties> getConnectionSet() {
		return fConnectionSettingBean.getConnectionSet();
	}

}