package hiro.yoshioka.sql.notes.ddl;

import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sql.resource.notes.ItemType;
import hiro.yoshioka.util.StringUtil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Field extends PardefElement implements Serializable {
	private static final long serialVersionUID = 5896051736870975193L;
	String name, allowMultiValues, description;
	KindType kind;
	ItemType type;
	Properties codeEventProperties;
	Properties fieldTypProperties = new Properties();
	private List<String> keywordsTextList;

	public Field(Node atts) {
		NamedNodeMap names = atts.getAttributes();
		name = Form.getAttrValueString(names, "name");
		type = ItemType.parseByName(Form.getAttrValueString(names, "type")
				.trim());
		kind = KindType.parse(Form.getAttrValueString(names, "kind").trim());
		allowMultiValues = Form.getAttrValueString(names, "allowMultiValues");
		description = Form.getAttrValueString(names, "description");
		if (type == ItemType.UNKNOWN) {
			System.out.println("UNKNOWN name:" + name + " type:"
					+ Form.getAttrValueString(names, "type") + " kind=" + kind
					+ " desc=" + description);
		}

		NodeList list = atts.getChildNodes();

		for (int i = 0; i < list.getLength(); i++) {
			Node child = list.item(i);
			if ("code".equals(child.getNodeName())) {
				NamedNodeMap names2 = child.getAttributes();
				String eventName = Form.getAttrValueString(names2, "event");
				Node firstChild = child.getFirstChild();
				if (firstChild != null) {
					setCodeEvent(eventName, firstChild.getTextContent());
				}
			} else if ("keywords".equals(child.getNodeName())) {
				NamedNodeMap names2 = child.getAttributes();
				String uiName = Form.getAttrValueString(names2, "ui");
				Node firstChild = child.getFirstChild();
				if (firstChild != null) {
					if ("textlist".equals(firstChild.getNodeName())) {
						NodeList list10 = firstChild.getChildNodes();
						keywordsTextList = new ArrayList<String>();
						for (int k = 0; k < list10.getLength(); k++) {
							keywordsTextList.add(list10.item(k)
									.getTextContent());
						}
					}
				}
			} else if ("datetimeformat".equals(child.getNodeName())) {
				// <field type='datetime' kind='computed' name='CreateDate'>
				// <datetimeformat show='date' date='yearmonthday'
				// time='hourminute' zone='never'/>
				NamedNodeMap names2 = child.getAttributes();
				Form.putAttrValueString(names2, "show", fieldTypProperties);
				Form.putAttrValueString(names2, "date", fieldTypProperties);
				Form.putAttrValueString(names2, "time", fieldTypProperties);
				Form.putAttrValueString(names2, "zone", fieldTypProperties);
			} else if (Node.TEXT_NODE == child.getNodeType()) {
				if (child.getTextContent().replaceAll("[\r\n]", "").trim()
						.length() > 0) {
					System.out.println("       firld Texttt["
							+ child.getTextContent() + "]");
				}
			} else {
				System.out.println("       ??field#child="
						+ child.getNodeName());
			}
		}

	}

	public void setCodeEvent(String event, String code) {
		if (codeEventProperties == null) {
			codeEventProperties = new Properties();
		}
		codeEventProperties.setProperty(event, code);
	}

	enum KindType {
		computedwhencomposed("作成時の計算結果"), editable("編集可能"), computedfordisplay(
				"表示用の計算結果"), computed("計算結果"), unknown("不明");

		String mean;

		private KindType(String mean) {
			this.mean = mean;
		}

		public String getMean() {
			return mean;
		}

		public static KindType parse(String kind) {
			for (KindType type : values()) {

				if (type.name().equalsIgnoreCase(kind)) {
					return type;
				}
			}
			System.out.println("kind [" + kind + "]is unknown");
			return unknown;
		}
	}

	public String toHtmlString(ResultSetDataHolder rdh, int row) {
		String value = StringUtil.EMPTY_STRING;
		if (rdh != null) {
			try {
				value = rdh.getStringData(row, name);
			} catch (Exception e) {
				System.out.println("name=[" + name + "] row=[" + row + "]");
				e.printStackTrace();
			}
		}
		StringBuilder buf = new StringBuilder();
		buf.append(String
				.format("<a href=\"javascript:void(0);\" class=\"hukidasi_box\">%n"));
		switch (type) {
		case NAMES:
		case AUTHORS:
		case READERS:
		case TEXT:
			if (KindType.editable.equals(kind)) {
				buf.append(String.format(
						"<input type='text' value='%s' tooltipText='%s'>%n",
						value, name));
			} else {
				buf.append(String
						.format("<input type='text' value='%s' tooltipText='%s' readonly='readonly'>%n",
								value, name));
			}
			break;
		case keyword:
			if (KindType.editable.equals(kind)) {
				buf.append(String.format("<select name='%s'> ", name));
				if (keywordsTextList != null && keywordsTextList.size() > 0) {
					for (String key : keywordsTextList) {
						buf.append(String.format(
								"<option value='00'>%s</option>", key));
					}
				} else {
					buf.append(String.format("<option value='00'>%s</option>",
							value));
				}
				buf.append("</select>");
			} else {
				buf.append(String.format(
						"<select name='%s' readonly='readonly'> ", name));
				if (keywordsTextList != null && keywordsTextList.size() > 0) {
					for (String key : keywordsTextList) {
						buf.append(String.format(
								"<option value='00'>%s</option>", key));
					}
				} else {
					buf.append(String.format("<option value='00'>%s</option>",
							value));
				}
				buf.append("</select>");
			}
			break;
		case RICHTEXT:
			if (KindType.editable.equals(kind)) {
				buf.append(String.format(
						"<textarea rows=2 cols=80 tooltipText='%s'>%n", name));
				buf.append(value);
				buf.append("</textarea>");
			} else {
				buf.append(String
						.format("<textarea rows=2 cols=80 tooltipText='%s' readonly='readonly'>%n",
								name));
				buf.append(value);
				buf.append("</textarea>");
			}
			break;
		default:
			if (KindType.editable.equals(kind)) {
				buf.append(String.format(
						"<input type='text' value='%s' tooltipText='%s'>%n",
						type.toString() + ":" + value, name));
			} else {
				buf.append(String
						.format("<input type='text' value='%s' tooltipText='%s' readonly='readonly'>%n",
								type.toString() + ":" + value, name));
			}
			break;
		}
		buf.append(String.format("<span class=\"hukidasi\">%n"));
		if (codeEventProperties == null) {
			buf.append(String.format("name=%s", name));
		} else {
			buf.append(String.format("name=%s<br>%n%s", name,
					codeEventProperties));
		}
		buf.append(String.format("%n</span>%n</a>"));
		return buf.toString();
	}
}
