package hiro.yoshioka.sql.notes.ddl;

import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.util.StringUtil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Table extends Par implements Serializable {
	private static final long serialVersionUID = 8925814590102105151L;
	List<Table.Row> rowList = new ArrayList<Table.Row>();
	private Map<Integer, Pardef> pardefMap = new LinkedHashMap<Integer, Pardef>();

	class Row {
		List<Table.Cell> cellList = new ArrayList<Table.Cell>();

		public Row(Node node) {
			NodeList listPar = node.getChildNodes();
			for (int j = 0; j < listPar.getLength(); j++) {
				Node childPar = listPar.item(j);
				if ("tablecell".equals(childPar.getNodeName())) {
					cellList.add(new Table.Cell(childPar));
				} else {
					System.err.println("       ??   Table.Cell#child="
							+ childPar.getNodeName());
				}
			}
		}
	}

	public void putParDef(Pardef pardef) {
		pardefMap.put(pardef.getId(), pardef);
	}

	class Cell {
		private List<Par> parList = new ArrayList<Par>();

		public void addPar(Par par) {
			parList.add(par);
		}

		public Cell(Node node) {
			NodeList listPar = node.getChildNodes();
			for (int j = 0; j < listPar.getLength(); j++) {
				Node childPar = listPar.item(j);
				if ("pardef".equals(childPar.getNodeName())) {
					Pardef pardef = new Pardef(childPar);
					putParDef(pardef);
				} else if ("par".equals(childPar.getNodeName())) {
					Par par = new Par(Table.this.getParent(), childPar);
					addPar(par);
					System.err.println("       ??   Row#child="
							+ childPar.getNodeName());
				}
			}
		}
	}

	public Table(Form form, Node atts) {
		super(form, null);
		NamedNodeMap names = atts.getAttributes();
		this.def = Form.getAttrValueInt(names, "def");
		NodeList listPar = ((Node) atts).getChildNodes();
		for (int j = 0; j < listPar.getLength(); j++) {
			Node childPar = listPar.item(j);
			if ("tablerow".equals(childPar.getNodeName())) {
				rowList.add(new Row(childPar));
			} else {
				System.err.println("       ??   par#child="
						+ childPar.getNodeName());
			}
		}
	}

	public String toHtmlString(ResultSetDataHolder rdh, int row) {

		StringBuilder buf = new StringBuilder();
		buf.append(String.format("<table >%n"));

		for (Table.Row r : rowList) {
			buf.append(String.format("  <tr>%n"));
			for (Table.Cell cell : r.cellList) {
				buf.append(String.format("    <td>%n"));
				for (Par element : cell.parList) {
					buf.append(String.format("    %s%n",
							element.toHtmlString(rdh, row)));
				}
				buf.append(String.format("    </td>%n"));
			}
			buf.append(String.format("  </row>%n"));
		}
		buf.append(String.format("</table>%n"));
		return buf.toString();
	}

}
