package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;

public abstract class AbsWolfDominoReflection {
	protected Class dominoClass;
	private Method recycle;
	protected Object targetInstance;
	protected ClassManager classManager;

	public AbsWolfDominoReflection(ClassManager classManager)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		this(classManager, null);
	}

	public AbsWolfDominoReflection(ClassManager classManager,
			Object targetInstance) throws MalformedURLException,
			ClassNotFoundException, SecurityException, NoSuchMethodException {
		this.classManager = classManager;
		this.targetInstance = targetInstance;
		dominoClass = classManager.getClassForName(getDominoClassName());
		try {
			recycle = dominoClass.getMethod("recycle");
		} catch (Exception e) {
		}
	}

	public abstract String getDominoClassName();

	public Object getTargetInstance() {
		return targetInstance;
	}

	public void setTargetInstance(Object targetInstance) {
		this.targetInstance = targetInstance;
	}

	public Class getDominoClass() {
		return dominoClass;
	}

	public final void recycle() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		recycle.invoke(targetInstance);
	}
}
