package hiro.yoshioka.sql.notes.reflect;

public enum LevelType {
	LEVEL_NOACCESS(0, "Ȃ"),

	LEVEL_DEPOSITOR(1, "e"),

	LEVEL_READER(2, "ǎ"),

	LEVEL_AUTHOR(3, "쐬"),

	LEVEL_EDITOR(4, "ҏW"),

	LEVEL_DESIGNER(5, "݌v"),

	LEVEL_MANAGER(6, "Ǘ"),

	ACL_MAX_ROLES(80, "݃O[v"),

	UNKOWN(-999999, "s");

	private int typeId;
	private String name;

	private LevelType(int typeId, String name) {
		this.typeId = typeId;
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public static LevelType parse(int typeId) {
		for (LevelType target : values()) {
			if (target.typeId == typeId) {
				return target;
			}
		}
		return UNKOWN;
	}

	public int getTypeId() {
		return typeId;
	}
}
