package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Vector;

public class WolfACL extends AbsWolfDominoReflection {
	Method isUniformAccess;
	Method getFirstEntry;
	Method getNextEntry;
	Method getRoles;
	WolfACLEntry wolf_acl_entry;

	public WolfACL(ClassManager classManager, Object targetInstance)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		super(classManager, targetInstance);
		// lotus.domino.ACLEntry
		wolf_acl_entry = new WolfACLEntry(classManager);
		isUniformAccess = dominoClass.getMethod("isUniformAccess");
		getRoles = dominoClass.getMethod("getRoles");
		getFirstEntry = dominoClass.getMethod("getFirstEntry");
		getNextEntry = dominoClass.getMethod("getNextEntry",
				wolf_acl_entry.getDominoClass());

	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.ACL";
	}

	public WolfACLEntry getFirstEntry() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		Object o = getFirstEntry.invoke(targetInstance);
		if (o == null) {
			return null;
		}
		wolf_acl_entry.setTargetInstance(o);
		return wolf_acl_entry;
	}

	public WolfACLEntry getNextEntry(WolfACLEntry aclEntry)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException {
		Object o = getNextEntry.invoke(targetInstance,
				aclEntry.getTargetInstance());
		if (o == null) {
			return null;
		}
		wolf_acl_entry.setTargetInstance(o);
		return wolf_acl_entry;
	}

	public Vector<String> getRoles() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Vector<String>) getRoles.invoke(targetInstance);
	}

	public boolean isUniformAccess() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Boolean) isUniformAccess.invoke(targetInstance);
	}

	public String toHtmlString() {
		StringBuilder buf = new StringBuilder();
		try {
			Vector<String> roles = getRoles();
			buf.append(String.format("<html>%n"));
			buf.append(String.format("<table border=1>%n"));
			buf.append(String.format("<thead>%n"));
			buf.append(String
					.format("  <tr><th rowspan=4>アクセス制御リスト</th><th colspan=11>属性</th><th colspan=%d>ロール</th><tr>%n",
							roles.size()));
			buf.append(String
					.format("  <tr><th colspan=2>-</th><th colspan=2>文書の</th><th colspan=2>個人</th><th colspan=2>共有</th><th colspan=2>ﾊﾟﾌﾞﾘｯｸ</th><th rowspan=2>文書を複製又はコピー</th>"));
			for (String role : roles) {
				buf.append(String.format("<th rowspan=2>%s</th>", role));
			}
			buf.append(String.format("</tr>%n"));
			buf.append(String
					.format("  <tr><th>種類</th><th>アクセス権</th><th>作成</th><th>削除</th><th>エージェントの作成</th><th>フォルダ／ビューの作成</th><th>フォルダ／ビューの作成</th><th>スクリプト／Ｊａｖaエージェントの作成</th><th>[読者]</th><th>[作成者]</th></tr>%n"));

			buf.append(String.format("</thead>%n"));
			buf.append(String.format("<tbody>%n"));
			WolfACLEntry entry = getFirstEntry();
			while (entry != null) {
				buf.append("  <tr>");
				buf.append(String.format("<td>%s</td>", entry.getName()));
				buf.append(String.format("<td>%s</td>", entry.getUserType()
						.getName()));
				buf.append(String.format("<td>%s</td>", entry.getLevel()
						.getName()));
				buf.append(String.format("<td>%b</td>",
						entry.isCanCreateDocuments()));
				buf.append(String.format("<td>%b</td>",
						entry.isCanDeleteDocuments()));
				buf.append(String.format("<td>%b</td>",
						entry.isCanCreatePersonalAgent()));
				buf.append(String.format("<td>%b</td>",
						entry.isCanCreatePersonalFolder()));
				buf.append(String.format("<td>%b</td>",
						entry.isCanCreateSharedFolder()));
				buf.append(String.format("<td>%b</td>",
						entry.isCanCreateLSOrJavaAgent()));
				buf.append(String.format("<td>%b</td>", entry.isPublicReader()));

				buf.append(String.format("<td>%b</td>", entry.isPublicWriter()));
				buf.append(String.format("<td>%b</td>", true));

				for (String role : roles) {
					if (entry.getRoles().contains(role)) {
						buf.append(String.format("<td>%b</td>",
								entry.isRoleEnabled(role)));
					} else {
						buf.append("<td>-</td>");
					}
				}

				buf.append(String.format("</tr>%n"));
				entry.recycle();
				entry = getNextEntry(entry);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		buf.append(String.format("</tbody>%n"));
		buf.append(String.format("</table>%n"));
		buf.append(String.format("</html>%n"));
		return buf.toString();
	}

	@Override
	public String toString() {
		StringBuilder buf = new StringBuilder();
		try {
			buf.append(String.format("ACL isUniformAccess[%b]%n",
					isUniformAccess()));

			WolfACLEntry entry = getFirstEntry();
			while (entry != null) {
				buf.append(entry);
				entry.recycle();
				entry = getNextEntry(entry);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return buf.toString();
	}
}
