package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class WolfDocument extends AbsWolfDominoReflection {
	Method getItems;
	Method hasItem;
	Method getFirstItem;
	Method getItemValue;
	Method getItemValueString;
	Method getUniversalID;

	// Method hasItem;

	public WolfDocument(ClassManager classManager, Object targetInstance)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		super(classManager, targetInstance);
		getUniversalID = dominoClass.getMethod("getUniversalID");
		getItems = dominoClass.getMethod("getItems");
		hasItem = dominoClass.getMethod("hasItem", String.class);
		getItemValue = dominoClass.getMethod("getItemValue", String.class);
		getItemValueString = dominoClass.getMethod("getItemValueString",
				String.class);
		getFirstItem = dominoClass.getMethod("getFirstItem", String.class);
	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.Document";
	}

	public boolean hasItem(String name) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		// System.out.println("hasItem=" + hasItem);
		// System.out.println("targetInstance=" + targetInstance);
		// System.out.println("name=" + name);
		// System.out.println("getCanonicalName=" +
		// targetInstance.getClass().getCanonicalName());
		return (Boolean) hasItem.invoke(targetInstance, name);
	}

	public Vector getItemValue(String name) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {

		return (Vector) getItemValue.invoke(targetInstance, name);
	}

	public String getUniversalID() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (String) getUniversalID.invoke(targetInstance);
	}

	public String getItemValueString(String name)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException {

		return (String) getItemValueString.invoke(targetInstance, name);
	}

	public WolfItem getFirstItem(String name) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			MalformedURLException, SecurityException, ClassNotFoundException,
			NoSuchMethodException {
		Object instance = getFirstItem.invoke(targetInstance, name);
		if (instance == null) {
			return null;
		}

		return new WolfItem(classManager, instance);
	}

	public List<WolfItem> getItems() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			MalformedURLException, SecurityException, ClassNotFoundException,
			NoSuchMethodException {
		Vector o = (Vector) getItems.invoke(targetInstance);
		if (o == null) {
			return Collections.EMPTY_LIST;
		}
		List<WolfItem> retList = new ArrayList<WolfItem>();
		for (Object instance : o) {
			WolfItem item = new WolfItem(classManager, instance);
			retList.add(item);
		}
		return retList;
	}

	@Override
	public String toString() {
		StringBuilder buf = new StringBuilder();
		try {
			buf.append(String.format("WolfDocument%n"));
			// ここでItemを取ってrecycleすると他で呼べなくなる
			// for (WolfItem item : getItems()) {
			// buf.append("  " + item);
			// item.recycle();
			// }
		} catch (Exception e) {
			e.printStackTrace();
		}
		return buf.toString();
	}
}
