package hiro.yoshioka.sql.params;

import hiro.yoshioka.sql.util.SQLUtil;
import hiro.yoshioka.util.StringUtil;

import java.sql.DatabaseMetaData;

public class OutPutParameter extends Parameter {
	public final int datatype;

	public final int columnType;

	public final String name;

	String result;

	public OutPutParameter(int index, int datatype) {
		this(StringUtil.EMPTY_STRING, index, datatype, DatabaseMetaData.procedureResultUnknown);
	}

	public OutPutParameter(String name, int index, int datatype, int columnType) {
		super(index);
		this.name = name;
		this.datatype = datatype;
		this.columnType = columnType;
	}

	public String getResult() {
		return result;
	}

	public void setResult(String string) {
		this.result = string;
	}

	@Override
	public String toString() {
		StringBuilder buf = new StringBuilder();
		buf.append("index=").append(index);
		buf.append(" name=[").append(name);
		buf.append("] datatype=").append(SQLUtil.getTypeString(datatype));
		buf.append("] columntype=").append(columnType);
		buf.append(" result=[").append(result).append("]");
		return buf.toString();
	}

}
