package hiro.yoshioka.sql.resource;

import java.util.ArrayList;

public class DBIndexRoot extends DBResource {
	private static final long serialVersionUID = 9999210546456L;
	private static DBCrossRefference[] EMPTY_REF = new DBCrossRefference[0];

	public DBIndexRoot(DBRoot root) {
		super(root);
	}

	public boolean contain(String pattern) {
		return false;
	}

	public DBCrossRefference getIndex(String name) {
		return (DBCrossRefference) _children.get(name);
	}

	public void putIndex(DBCrossRefference index) {
		putResource(index.getName(), index);
	}

	public DBCrossRefference[] getCrossReferences(DBTable table) {
		ArrayList<DBCrossRefference> list = new ArrayList<DBCrossRefference>();
		IDBColumn[] cols = table.getColumns();
		IDBResource[] allIndex = listArrayResources();
		for (int i = 0; i < cols.length; i++) {
			for (int j = 0; j < allIndex.length; j++) {
				DBCrossRefference cros = (DBCrossRefference) allIndex[j];
				if (cros.isPk(cols[i])) {
					list.add(cros);
				}
			}
		}
		return list.toArray(new DBCrossRefference[list.size()]);
	}
}