package hiro.yoshioka.sql.resource;

import java.util.List;

public interface IDBTable extends IDBResource, IAliasExtention, ITextExtension {
	String TABLE_TYPE_TABLE = "TABLE";

	String TABLE_TYPE_VIEW = "VIEW";

	String TABLE_TYPE_SYSTEM_TABLE = "SYSTEM TABLE";

	String TABLE_TYPE_G_TMP = "GLOBAL TEMPORARY";

	String TABLE_TYPE_L_TMP = "LOCAL TEMPORARY";

	String TABLE_TYPE_ALIAS = "ALIAS";

	String TABLE_TYPE_SYNONYM = "SYNONYM";

	IDBColumn[] getColumns();

	DBCrossRefference[] getCrossReferences();

	public int[] getPkPositions();

	public boolean hasPk();

	boolean isTable();

	boolean isView();

	void setSelectAll();

	boolean getSelectAll();

	boolean isSynonym();

	boolean isSystem();

	boolean isProcudeure();

	boolean isFunction();

	boolean isDictionary();

	boolean isShadow();

	IDBColumn[] getInputColumns();

	IDBColumn[] getOutputColumns();

	IDBColumn getReturnColumn();

	// void addIndex(String index_name,String column_name);
	/**
	 * @param schemaString
	 * @param tableNameString
	 * @param columnString
	 * @return
	 */
	List getProposal(IDBSchema another, String schemaString,
			String tableNameString, String columnString);

	IDBTable clone();

	void removeAllColumns();

}