package hiro.yoshioka.sql.resource;

import java.util.ArrayList;
import java.util.List;

public class TmpSelectionDBTable extends DBTable {
	private static final long serialVersionUID = 999901010156L;
	private static List fNULLList = new ArrayList();

	public TmpSelectionDBTable() {
		super((IDBSchema) null);
		fTmpSelection = true;
	}

	/**
	 * コンテンツアシスト用IDBColumn List返却。
	 * 
	 * @return アシスト用IDBColumn List
	 */
	public List getProposal(IDBSchema another, String schemaString,
			String tableNameString, String columnString) {

		if (schemaString.length() > 0) {// スキーマ、テーブル　又はエイリアスがあり
			if (fLogger.isDebugEnabled()) {
				fLogger.debug("スキーマ、テーブル　又はエイリアスがあり[" + schemaString + "]");
			}
			if (tableNameString.length() > 0) {
				if (fLogger.isInfoEnabled()) {
					fLogger.info("tableNameString.length()>0");
				}
				if (columnString.length() > 0) { // 全て指定
					if (fLogger.isDebugEnabled()) {
						fLogger.debug("columnString.length()>0");
					}
					return startsWithResourceLists(columnString);
				}
				return listResources();
			}
			if (getAlias().equalsIgnoreCase(schemaString)) {// エイリアスが一致
				if (fLogger.isDebugEnabled()) {
					fLogger.debug("エイリアスが一致");
				}
				if (columnString.length() > 0) {
					return startsWithResourceLists(columnString);
				}
				return listResources();
			}
			if (getName().equalsIgnoreCase(schemaString)) {// テーブル名が一致
				if (fLogger.isDebugEnabled()) {
					fLogger.debug("テーブル名が一致");
				}
				if (columnString.length() > 0) { // 全て指定
					return startsWithResourceLists(columnString);
				}
				return listResources();
			}
			if (another != null && !another.equals(getParent())) {
				if (fLogger.isDebugEnabled()) {
					fLogger.debug("別スキーマのテーブル候補を探索");
				}
				List list = new ArrayList();
				if (getParent() != null
						&& getParent().getUName().startsWith(schemaString)) {
					list.add(this);
				}
				return list;
			}
			return fNULLList;
		}
		if (columnString.length() == 0) {
			return listResources();
		}
		return startsWithResourceLists(columnString);
	}

	public boolean isTable() {
		return true;
	}

	public boolean isView() {
		return false;
	}

	public boolean isSynonym() {
		return false;
	}

	public boolean isProcudeure() {
		return false;
	}

	public boolean isDictionary() {
		return false;
	}

	public boolean isSystem() {
		return false;
	}

}