package hiro.yoshioka.sql.resource.notes;

import hiro.yoshioka.sql.resource.DBColumn;
import hiro.yoshioka.sql.resource.IDBTable;

import java.io.Serializable;
import java.sql.Types;

public class NotesDBColumn extends DBColumn implements Serializable {
	private static final long serialVersionUID = -5178849167324045521L;
	private boolean richText;
	private ItemType itemType;

	public NotesDBColumn(IDBTable table) {
		super(table);
	}

	public void setRichText(boolean richText) {
		this.richText = richText;
	}

	public boolean isRichText() {
		return richText;
	}

	@Override
	public boolean isNotNull() {
		return super.isNotNull();
	}

	@Override
	public boolean isBlob() {
		return getDataType() == Types.BLOB;
	}

	@Override
	public boolean isBinary() {
		return getDataType() == Types.BINARY
				|| getDataType() == Types.VARBINARY
				|| getDataType() == Types.LONGVARBINARY;
	}

	@Override
	public boolean isDate() {
		return getDataType() == Types.DATE;
	}

	@Override
	public boolean isTime() {
		return getDataType() == Types.TIME;
	}

	@Override
	public boolean isTimeStamp() {
		return getDataType() == Types.TIMESTAMP;
	}

	@Override
	public boolean isNumeric() {
		int dataType = getDataType();
		return dataType == 4 || dataType == 6 || dataType == 8
				|| dataType == -5 || dataType == 3 || dataType == 2
				|| dataType == 5 || dataType == -6;
	}

	@Override
	public boolean isBigDecimal() {
		return getDataType() == 3;
	}

	@Override
	public boolean isString() {
		return getDataType() == 1 || getDataType() == -1 || getDataType() == 12;
	}

	public void setItemType(ItemType itemType) {
		this.itemType = itemType;
	}

	@Override
	public int getDataType() {
		if (this.itemType == null) {
			super.getDataType();
		}
		return this.itemType.getSQLTypes();
	}

	@Override
	public String getDataTypeString() {
		if (this.itemType == null) {
			return super.getDataTypeString();
		}
		return this.itemType.toString();
	}
}