package hiro.yoshioka.sql.resource.notes;

import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sql.notes.ddl.Form;
import hiro.yoshioka.sql.notes.ddl.NotesDXLParser2;
import hiro.yoshioka.sql.resource.DBDictionaryRoot;
import hiro.yoshioka.sql.resource.DBTable;
import hiro.yoshioka.sql.resource.IDBSchema;

import java.io.Serializable;

public class NotesDBTable extends DBTable implements Serializable {
	private static final long serialVersionUID = 2609783121262289704L;
	private Form form;

	public NotesDBTable(IDBSchema schema) {
		super(schema);
	}

	public NotesDBTable(DBDictionaryRoot droot) {
		super(droot);
	}

	public void setForm(Form form) {
		this.form = form;
	}

	public Form getForm() {
		return form;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append(getName());
		String[] aliases = getAllAlias();
		if (aliases.length > 0) {
			buf.append(" [");
			for (String alias : aliases) {
				buf.append(alias + ",");
			}
			buf.append("]");
		}

		return buf.toString();
	}

	public String toHtmlString(ResultSetDataHolder rdh, int row) {
		return NotesDXLParser2.toHtmlString(rdh, row,
				((NotesDBSchema) getParent()).getDatabase(), form);
	}
}