package hiro.yoshioka.sql.resource.xml;

import hiro.yoshioka.sql.resource.DBCrossRefference;
import hiro.yoshioka.sql.resource.IDBColumn;

import java.sql.DatabaseMetaData;
import java.util.Iterator;
import java.util.TreeSet;

public class DBCrossRefferenceValue {
	private TreeSet<STC> pkList = new TreeSet<STC>();
	private TreeSet<STC> fkList = new TreeSet<STC>();
	private int updateRule;
	private int deleteRule;
	private String name;

	public DBCrossRefferenceValue() {
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof DBCrossRefferenceValue) {
			DBCrossRefferenceValue target = (DBCrossRefferenceValue) obj;
			System.out.println("ME:" + getName() +"/" + target.getName());
			if (getName().equals(target.getName())
					&& pkList.first().column
							.equals(target.pkList.first().column)) {
				System.out.println("return TRUEEEEEEEEEEEEEEEEEEEEEEEEEEE");
				return true;
			}
		}
		return super.equals(obj);
	}

	public DBCrossRefferenceValue(DBCrossRefference resource) {
		setName(resource.getName());
		setDeleteRule(resource.getDeleteRule());
		setUpdateRule(resource.getUpdateRule());
		for (Iterator<IDBColumn> ite = resource.fkList.iterator(); ite
				.hasNext();) {
			putFkColumn(ite.next());
		}
		for (Iterator<IDBColumn> ite = resource.pkList.iterator(); ite
				.hasNext();) {
			putPkColumn(ite.next());
		}
	}

	public void putPkColumn(IDBColumn column) {
		pkList.add(new STC(column));
	}

	public void putFkColumn(IDBColumn column) {
		fkList.add(new STC(column));
	}

	public void setUpdateRule(int rule) {
		this.updateRule = rule;
	}

	public void setDeleteRule(int rule) {
		this.deleteRule = rule;
	}

	public String getDeleteRuleString() {
		switch (deleteRule) {
		case DatabaseMetaData.importedKeyNoAction:
			return "NoAction";
		case DatabaseMetaData.importedKeyCascade:
			return "Cascade";
		case DatabaseMetaData.importedKeySetNull:
			return "SetNull";
		case DatabaseMetaData.importedKeySetDefault:
			return "SetDefault";
		case DatabaseMetaData.importedKeyRestrict:
			return "Restrict";

		default:
			return "unKnown";
		}
	}

	public String getUpdateRuleString() {
		switch (updateRule) {
		case DatabaseMetaData.importedKeyNoAction:
			return "NoAction";
		case DatabaseMetaData.importedKeyCascade:
			return "Cascade";
		case DatabaseMetaData.importedKeySetNull:
			return "SetNull";
		case DatabaseMetaData.importedKeySetDefault:
			return "SetDefault";
		case DatabaseMetaData.importedKeyRestrict:
			return "Restrict";

		default:
			return "unKnown";
		}
	}

	public String toString() {
		return name + ":" + pkList + " ⇒" + fkList + " U["
				+ getUpdateRuleString() + "] D[" + getDeleteRuleString() + "]";
	}

	public TreeSet<STC> getPkList() {
		return pkList;
	}

	public void setPkList(TreeSet<STC> pkList) {
		this.pkList = pkList;
	}

	public TreeSet<STC> getFkList() {
		return fkList;
	}

	public void setFkList(TreeSet<STC> fkList) {
		this.fkList = fkList;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getUpdateRule() {
		return updateRule;
	}

	public int getDeleteRule() {
		return deleteRule;
	}
}
