package hiro.yoshioka.sql.util;

import hiro.yoshioka.chart.ChartInfo;
import hiro.yoshioka.sdh.DefaultHyperLinkAction;
import hiro.yoshioka.sdh.ResultSetDataHolder;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class CommentInfo {
	public CommentInfo(boolean supportChartResultSet) {
		this.supportChartResultSet = supportChartResultSet;
	}

	public boolean supportBarGraph;
	public int supportMultiLine = 1;
	public boolean supportChartResultSet;
	public ArrayList<ChartInfo> chartList = new ArrayList<ChartInfo>();
	public TreeMap<Integer, LinkInfo> linkMap = new TreeMap<Integer, LinkInfo>();
	public List<String> interceptorsList = new ArrayList<String>();

	@Override
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("supportBarGraph:" + supportBarGraph);
		buf.append(" supportMultiLine:" + supportMultiLine);
		buf.append("\n chartList:" + chartList);
		buf.append("\n linkList:" + linkMap);
		buf.append("\n interceptorList:" + interceptorsList);

		return buf.toString();
	}

	public DefaultHyperLinkAction createLinkAction() {
		Integer[] ls = linkMap.keySet().toArray(new Integer[0]);
		final int[] idex = new int[ls.length];
		for (int i = 0; i < idex.length; i++) {
			idex[i] = ls[i];
		}
		return new DefaultHyperLinkAction(idex) {
			public void activateHyperLink(ResultSetDataHolder rdh, int colIdx,
					int row) {
				System.out.println("clicked[" + row + "/" + colIdx + ":"
						+ rdh.getStringRecordRow(row)[colIdx].getString());
				LinkInfo info = linkMap.get(colIdx);
				info.execute(rdh, row);
			}
		};
	}

	public void add(String kind, String info) {
		String[] param = info.split(":");
		// if ("PIE".equalsIgnoreCase(kind)) {
		// chartList.add(new PieChartInfo(param));
		// } else if ("TIME".equalsIgnoreCase(kind)) {
		// chartList.add(new TimeChartInfo(param));
		// }
	}

	public void addLink(int colIdx, String bind, String popup, String kind,
			String message) {
		int[] ibind = new int[0];
		if (bind != null) {
			String[] vs = bind.trim().split(",");
			ArrayList<Integer> list = new ArrayList<Integer>();
			for (int j = 0; j < vs.length; j++) {
				try {
					list.add(new Integer(vs[j].trim()));
				} catch (NumberFormatException e) {
				}
			}
			ibind = new int[list.size()];
			for (int j = 0; j < list.size(); j++) {
				ibind[j] = list.get(j);
			}
		}
		boolean doPopUp = false;
		if (popup != null) {
			doPopUp = Boolean.parseBoolean(popup);
		}
		if ("HREF".equalsIgnoreCase(kind)) {
			linkMap.put(colIdx, new LinkHrefInfo(colIdx, message, ibind,
					doPopUp));
		} else if ("SQL".equalsIgnoreCase(kind)) {
			// linkMap.put(colIdx,
			// new LinkSQLInfo(colIdx, message, ibind, doPopUp));
		}
	}
}
