package hiro.yoshioka.sql.util;

import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.engine.TransactionRequest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class LinkSQLInfo extends LinkInfo implements IRequestListener,
		Runnable {
	protected transient Log fLogger = LogFactory.getLog(getClass());
	public int colIdx;
	public String file;
	public int[] bind;
	TransactionRequest fTransactionRequest;

	public LinkSQLInfo(int colIdx, String message, int[] bind, boolean popUp) {
		super(colIdx);
		this.doPopUp = popUp;
		this.file = message;
		this.bind = bind;
	}

	@Override
	public String toString() {
		return super.toString() + " BIND:" + bind + " FILE=" + file;
	}

	protected String read(String file) {
		try {
			File f = new java.io.File("sql/" + file);
			BufferedReader in = new BufferedReader(new FileReader(f));

			try {
				StringBuffer buf = new StringBuffer();
				String line;
				for (; (line = in.readLine()) != null;) {
					buf.append(line).append("\n");
				}
				return buf.toString();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				if (in != null) {
					try {
						in.close();
					} catch (IOException e1) {
						e1.printStackTrace();
					}
				}
			}

		} catch (Throwable e) {
			e.printStackTrace();
		}
		return null;
	}

}
