package hiro.yoshioka.sql.util;

import java.sql.Types;

public enum SQLTypesNum {
	BIT("BIT", Types.BIT), TINYINT("TINYINT", Types.TINYINT), SMALLINT(
			"SMALLINT", Types.SMALLINT), INTEGER("INTEGER", Types.INTEGER), BIGINT(
			"BIGINT", Types.BIGINT), FLOAT("FLOAT", Types.FLOAT), REAL("REAL",
			Types.REAL), DOUBLE("DOUBLE", Types.DOUBLE), NUMERIC("NUMERIC",
			Types.NUMERIC), DECIMAL("DECIMAL", Types.DECIMAL), CHAR("CHAR",
			Types.CHAR), VARCHAR("VARCHAR", Types.VARCHAR), LONGVARCHAR(
			"LONGVARCHAR", Types.LONGVARCHAR), DATE("DATE", Types.DATE), TIME(
			"TIME", Types.TIME), TIMESTAMP("TIMESTAMP", Types.TIMESTAMP), BINARY(
			"BINARY", Types.BINARY), VARBINARY("VARBINARY", Types.VARBINARY), LONGVARBINARY(
			"LONGVARBINARY", Types.LONGVARBINARY), OTHER("OTHER", Types.OTHER), JAVA_OBJECT(
			"JAVA_OBJECT", Types.JAVA_OBJECT), DISTINCT("DISTINCT",
			Types.DISTINCT), STRUCT("STRUCT", Types.STRUCT), ARRAY("ARRAY",
			Types.ARRAY), BLOB("BLOB", Types.BLOB), CLOB("CLOB", Types.CLOB), REF(
			"REF", Types.REF), DATALINK("DATALINK", Types.DATALINK), BOOLEAN(
			"BOOLEAN", Types.BOOLEAN), ROWID("ROWID", Types.ROWID), NCHAR(
			"NCHAR", Types.NCHAR), NVARCHAR("NVARCHAR", Types.NVARCHAR), LONGNVARCHAR(
			"LONGNVARCHAR", Types.LONGNVARCHAR), NCLOB("NCLOB", Types.NCLOB), SQLXML(
			"SQLXML", Types.SQLXML);

	public static final SQLTypesNum[] TYPES = { BIT, TINYINT, SMALLINT,
			INTEGER, BIGINT, FLOAT, REAL, DOUBLE, NUMERIC, DECIMAL, CHAR,
			VARCHAR, LONGNVARCHAR, LONGNVARCHAR, DATE, TIME, TIMESTAMP, BINARY,
			VARBINARY, LONGVARBINARY, OTHER, JAVA_OBJECT, DISTINCT, STRUCT,
			ARRAY, BLOB, CLOB, REF, DATALINK, BOOLEAN, ROWID, NCHAR, NVARCHAR,
			LONGNVARCHAR, LONGVARCHAR, NCLOB, SQLXML };

	private String message;
	private int type;

	private SQLTypesNum(String message, int type) {
		this.message = message;
		this.type = type;
	}

	public static SQLTypesNum parse(int type) {
		for (int i = 0; i < TYPES.length; i++) {
			if (TYPES[i].type ==type) {
				return TYPES[i];
			}
		}
		return null;
	}
	public static SQLTypesNum parse(String message) {
		for (int i = 0; i < TYPES.length; i++) {
			if (TYPES[i].message.equalsIgnoreCase(message)) {
				return TYPES[i];
			}
		}
		if ("VARCHAR2".equalsIgnoreCase(message)) {
			return SQLTypesNum.VARCHAR;
		}
		return null;
	}

	public String getMessage() {
		return message;
	}

	public int getType() {
		return type;
	}
}
