package hiro.yoshioka.sql.view;

import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.util.ConnectionSettingDialog;
import hiro.yoshioka.util.ImageUtil;
import hiro.yoshioka.util.ui.MySubjectControlContentAssistant;

import java.io.IOException;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class DBResourceCompositeMaker {
	DBResourceTreeViewer viewer;
	Text fSearchText;
	MySubjectControlContentAssistant fMySubjectControlContentAssistant;
	boolean runningOnEclipse;
	Composite c;

	private DBResourceCompositeMaker(boolean runningOnEclipse) {
		this.runningOnEclipse = runningOnEclipse;
	}

	public static DBResourceCompositeMaker getInstance(boolean runningOnEclipse) {
		return new DBResourceCompositeMaker(runningOnEclipse);
	}

	public Composite getMainComposite() {
		return c;
	}

	private void createSearchText(Composite parent) {
		Composite c = new Composite(parent, SWT.BORDER);
		c.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		GridLayout gl = new GridLayout(3, false);
		gl.horizontalSpacing = 0;
		gl.verticalSpacing = 0;
		gl.marginWidth = 0;
		gl.marginHeight = 0;
		c.setLayout(gl);
		Button configBtn = new Button(c, SWT.PUSH);
		configBtn.setText("Config");
		configBtn
				.setImage(ImageUtil.getImage(ImageUtil.ACTION_00_TREE_REFRESH));
		configBtn.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ConnectionSettingDialog dialog = new ConnectionSettingDialog(
						e.display.getActiveShell(), SQLServerThread
								.getSQLServer().getConnectionSettingBean());
				if (dialog.open() == ConnectionSettingDialog.OK) {
					try {
						SQLServerThread.getSQLServer()
								.changeConnectionProperties(
										dialog.getChangeType(),
										dialog.getConnectionSet());
						viewer.refresh();
					} catch (IOException e1) {
						e1.printStackTrace();
					}
				}
			}
		});
		new Label(c, SWT.NONE).setText(" Filter");
		fSearchText = new Text(c, SWT.SINGLE | SWT.BORDER);
		fSearchText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		fSearchText.setToolTipText("AutoCompletion <CTRL+SPACE>");
		if (runningOnEclipse) {
			fMySubjectControlContentAssistant = new MySubjectControlContentAssistant(
					fSearchText);
		} else {
			fSearchText.addKeyListener(new KeyAdapter() {

				@Override
				public void keyReleased(org.eclipse.swt.events.KeyEvent e) {
					System.out.println("verify!!!! [" + e + "]");
					if (e.stateMask == SWT.CTRL && e.character == ' ') {
						e.doit = false;
					} else if (e.character == '\r' || e.character == '\n') {
						viewer.pressEnter(fSearchText.getText());
						e.doit = false;
					}
				}
			});
		}
	}

	public Composite createControl(Composite parent) {
		c = new Composite(parent, SWT.NONE);
		GridLayout g = new GridLayout();
		g.marginBottom = 0;
		g.marginTop = 0;
		g.marginLeft = 0;
		g.marginRight = 0;
		g.marginWidth = 0;
		g.marginHeight = 0;
		g.verticalSpacing = 0;
		g.horizontalSpacing = 0;
		c.setLayout(g);

		createSearchText(c);

		viewer = new DBResourceTreeViewer(c);
		if (runningOnEclipse) {
			fMySubjectControlContentAssistant.addPressEnterListener(viewer);
		}
		viewer.setInput(null);
		viewer.getTree().setLayoutData(new GridData(GridData.FILL_BOTH));
		return c;

	}

	public DBResourceTreeViewer getTreeViewer() {
		return viewer;
	}

	public Text getSearchText() {
		return fSearchText;
	}

}
