package hiro.yoshioka.sql.view;

import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.IDBResource;
import hiro.yoshioka.sql.resource.IDBTable;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class DBTreeFilter extends ViewerFilter {
	String _pattern;

	/** テーブル */
	boolean hideTable;

	/** ビュー */
	boolean hideView;

	/** シノニム */
	boolean hideSysnonym;

	public boolean select(Viewer viewer, Object parentElement, Object element) {
		if (element instanceof IDBTable) {
			IDBTable t = (IDBTable) element;
			if (hideTable && t.isTable()) {
				return false;
			}
			if (hideView && t.isView()) {
				return false;
			}
			if (hideSysnonym && t.isSynonym()) {
				return false;
			}
		}

		if (_pattern != null) {
			if (element instanceof ConnectionProperties) {
				ConnectionProperties res = (ConnectionProperties) element;

			} else if (element instanceof IDBResource) {
				IDBResource res = (IDBResource) element;
				// if (res instanceof IDBColumn) {
				// IDBTable t = (IDBTable) res.getParent();
				// if (t.contain(_pattern)) {
				// return true;
				// }
				// }
				return res.contain(_pattern);
			}
		}
		return true;
	}

	public void setPattern(String pattern) {
		_pattern = pattern;
	}

	public void filterResource(int kind) {
		if (kind == IDBResource.IDB_TABLE) {
			hideTable = !hideTable;
		} else if (kind == IDBResource.IDB_VIEW) {
			hideView = !hideView;
		} else if (kind == IDBResource.IDB_SYNONYM) {
			hideSysnonym = !hideSysnonym;
		}
	}
}