/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.sql.yaml.bean;

import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sql.yaml.bean.ComparisionOperatorType;
import hiro.yoshioka.sql.yaml.bean.Expect;
import hiro.yoshioka.sql.yaml.bean.ResultSetValidatorType;
import hiro.yoshioka.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResultExpect
extends Expect {
    static final Pattern P = Pattern.compile("(\\d+)\\s*/\\s*(\\S+)");
    static final Pattern P_r1c1 = Pattern.compile("(\\d+)\\s*:\\s*(\\S+)");
    public String type = ResultSetValidatorType.None.name();
    public String rowcol;
    private int row;
    private String col;

    public ResultSetValidatorType getResultSetValidatorType() {
        return ResultSetValidatorType.parse(this.type);
    }

    public boolean hasRowCol() {
        return !StringUtil.isEmpty((Object)this.rowcol);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String validate(ResultSetDataHolder rdh) {
        try {
            ComparisionOperatorType operator_type = this.getOperatorType();
            if (this.getResultSetValidatorType().isCount()) {
                long count = Long.parseLong(this.value);
                if (count <= 0L) return null;
                switch (operator_type) {
                    case GreatorEqual: {
                        if ((long)rdh.getRowCount() < count) return String.format("[%s]EXPECT king[%s] %d   %d , but was not...", operator_type.getTypeString(), this.type, count, rdh.getRowCount());
                        return null;
                    }
                    case GreatorThan: {
                        if ((long)rdh.getRowCount() <= count) return String.format("[%s]EXPECT king[%s] %d   %d , but was not...", operator_type.getTypeString(), this.type, count, rdh.getRowCount());
                        return null;
                    }
                    case LessEqual: {
                        if ((long)rdh.getRowCount() > count) return String.format("[%s]EXPECT king[%s] %d   %d , but was not...", operator_type.getTypeString(), this.type, count, rdh.getRowCount());
                        return null;
                    }
                    case LessThan: {
                        if ((long)rdh.getRowCount() >= count) return String.format("[%s]EXPECT king[%s] %d   %d , but was not...", operator_type.getTypeString(), this.type, count, rdh.getRowCount());
                        return null;
                    }
                    default: {
                        if (count != (long)rdh.getRowCount()) return String.format("[%s]EXPECT king[%s] %d   %d , but was not...", operator_type.getTypeString(), this.type, count, rdh.getRowCount());
                        return null;
                    }
                }
            }
            String targetString = null;
            Matcher mR1C1 = P_r1c1.matcher(this.rowcol);
            if (mR1C1.find()) {
                this.row = Integer.parseInt(mR1C1.group(1)) - 1;
                this.col = mR1C1.group(2);
                targetString = rdh.getStringRecordRow(this.row)[Integer.parseInt(this.col)].getString();
            } else {
                Matcher m = P.matcher(this.rowcol);
                if (m.find()) {
                    this.row = Integer.parseInt(m.group(1)) - 1;
                    this.col = m.group(2);
                    targetString = rdh.getStringData(this.row, this.col);
                }
            }
            if (ComparisionOperatorType.Contain.equals((Object)operator_type) ? targetString.contains(this.value) : (operator_type.isNotContain() ? !targetString.contains(this.value) : ComparisionOperatorType.Equal.equals((Object)operator_type) && targetString.equals(this.value))) {
                return null;
            }
            try {
                long longValue = Long.parseLong(targetString);
                long expectValue = Long.parseLong(this.value);
                switch (operator_type) {
                    case GreatorEqual: {
                        if (longValue < expectValue) return String.format("[%s]EXPECT kind[%s] %s %s   , but was not...", operator_type.getTypeString(), this.type, this.value, targetString);
                        return null;
                    }
                    case GreatorThan: {
                        if (longValue <= expectValue) return String.format("[%s]EXPECT kind[%s] %s %s   , but was not...", operator_type.getTypeString(), this.type, this.value, targetString);
                        return null;
                    }
                    case LessEqual: {
                        if (longValue > expectValue) return String.format("[%s]EXPECT kind[%s] %s %s   , but was not...", operator_type.getTypeString(), this.type, this.value, targetString);
                        return null;
                    }
                    case LessThan: {
                        if (longValue >= expectValue) return String.format("[%s]EXPECT kind[%s] %s %s   , but was not...", operator_type.getTypeString(), this.type, this.value, targetString);
                        return null;
                    }
                    default: {
                        return String.format("[%s]EXPECT kind[%s] %s %s   , but was not...", operator_type.getTypeString(), this.type, this.value, targetString);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                int resulti = targetString.compareTo(this.value);
                switch (operator_type) {
                    case GreatorEqual: {
                        if (resulti < 0) return String.format("[%s]EXPECT kind[%s] %s %s   , but was not...", operator_type.getTypeString(), this.type, this.value, targetString);
                        return null;
                    }
                    case GreatorThan: {
                        if (resulti <= 0) return String.format("[%s]EXPECT kind[%s] %s %s   , but was not...", operator_type.getTypeString(), this.type, this.value, targetString);
                        return null;
                    }
                    case LessEqual: {
                        if (resulti > 0) return String.format("[%s]EXPECT kind[%s] %s %s   , but was not...", operator_type.getTypeString(), this.type, this.value, targetString);
                        return null;
                    }
                    case LessThan: {
                        if (resulti >= 0) return String.format("[%s]EXPECT kind[%s] %s %s   , but was not...", operator_type.getTypeString(), this.type, this.value, targetString);
                        return null;
                    }
                }
            }
            return String.format("[%s]EXPECT kind[%s] %s %s   , but was not...", operator_type.getTypeString(), this.type, this.value, targetString);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public Integer getExpectedRow() {
        try {
            Matcher mR1C1 = P_r1c1.matcher(this.rowcol);
            if (mR1C1.find()) {
                return Integer.parseInt(mR1C1.group(1));
            }
            Matcher m = P.matcher(this.rowcol);
            if (m.find()) {
                return Integer.parseInt(m.group(1));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    public Integer getExpectedCol() {
        try {
            Matcher mR1C1 = P_r1c1.matcher(this.rowcol);
            if (mR1C1.find()) {
                return Integer.parseInt(mR1C1.group(2));
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

