/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.yaml.editors.text;

import hiro.yoshioka.yaml.editors.text.YamlConfiguration;
import hiro.yoshioka.yaml.editors.text.YamlDocumentProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class YamlTextEditor
extends TextEditor {
    ICharacterPairMatcher pairMatcher;
    private ProjectionSupport fProjectionSupport;
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public YamlTextEditor() {
        this.setSourceViewerConfiguration(new YamlConfiguration());
        this.setDocumentProvider((IDocumentProvider)new YamlDocumentProvider());
    }

    public void dispose() {
        this.pairMatcher.dispose();
        super.dispose();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), true, styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.install();
        try {
            ITextViewerExtension2 extension = (ITextViewerExtension2)this.getSourceViewer();
            this.pairMatcher = new DefaultCharacterPairMatcher(new char[]{'<', '>', '(', ')', '{', '}'});
            MatchingCharacterPainter painter = new MatchingCharacterPainter(this.getSourceViewer(), this.pairMatcher);
            painter.setColor(Display.getDefault().getSystemColor(3));
            extension.addPainter((IPainter)painter);
        }
        catch (Throwable e) {
            this.log.error((Object)"", e);
        }
    }
}

