/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabViewConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabViewTask;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;

public class CrosstabViewHandle
extends AbstractCrosstabItemHandle
implements ICrosstabViewConstants,
ICrosstabConstants {
    protected CrosstabViewHandle(DesignElementHandle element) {
        super(element);
    }

    public LevelHandle getMirroredStartingLevel() {
        return (LevelHandle)this.handle.getElementProperty("mirrorStartingLevel");
    }

    public void setMirroredStartingLevel(LevelHandle value) throws SemanticException {
        this.handle.setProperty("mirrorStartingLevel", (Object)(value == null ? null : value.getQualifiedName()));
    }

    public PropertyHandle getGrandTotalProperty() {
        return this.handle.getPropertyHandle("grandTotal");
    }

    public PropertyHandle getViewsProperty() {
        return this.handle.getPropertyHandle("views");
    }

    public List getMembers() {
        return this.handle.getPropertyHandle("members").getContents();
    }

    public void addMember(MemberValueHandle value) throws SemanticException {
        this.handle.getPropertyHandle("members").add((DesignElementHandle)value);
    }

    public DimensionViewHandle getDimension(String name) {
        int i = 0;
        while (i < this.getDimensionCount()) {
            String cubeDimensionName;
            DimensionViewHandle dimensionView = this.getDimension(i);
            if (dimensionView != null && ((cubeDimensionName = dimensionView.getCubeDimensionName()) != null && cubeDimensionName.equals(name) || cubeDimensionName == null && name == null)) {
                return dimensionView;
            }
            ++i;
        }
        return null;
    }

    public DimensionViewHandle getDimension(int index) {
        DesignElementHandle element = this.getViewsProperty().getContent(index);
        return (DimensionViewHandle)CrosstabUtil.getReportItem(element, "DimensionView");
    }

    public int getDimensionCount() {
        return this.getViewsProperty().getContentCount();
    }

    public DimensionViewHandle insertDimension(DimensionHandle dimensionHandle, int index) throws SemanticException {
        ExtendedItemHandle extendedItem = CrosstabExtendedItemFactory.createDimensionView(this.moduleHandle, dimensionHandle);
        if (extendedItem == null) {
            return null;
        }
        if (dimensionHandle != null && this.getDimension(dimensionHandle.getQualifiedName()) != null) {
            logger.log(Level.SEVERE, "Error.CrosstabException.DUPLICATE_DIMENSION", dimensionHandle.getQualifiedName());
            throw new CrosstabException(this.handle.getElement(), Messages.getString("Error.CrosstabException.DUPLICATE_DIMENSION", dimensionHandle.getQualifiedName()));
        }
        this.getViewsProperty().add((DesignElementHandle)extendedItem, index);
        return (DimensionViewHandle)CrosstabUtil.getReportItem((DesignElementHandle)extendedItem);
    }

    public void removeDimension(String name) throws SemanticException {
        new CrosstabViewTask(this).removeDimension(name);
    }

    public void removeDimension(int index) throws SemanticException {
        new CrosstabViewTask(this).removeDimension(index);
    }

    public CrosstabCellHandle getGrandTotal() {
        PropertyHandle propHandle = this.getGrandTotalProperty();
        return propHandle.getContentCount() == 0 ? null : (CrosstabCellHandle)CrosstabUtil.getReportItem(propHandle.getContent(0), "CrosstabCell");
    }

    public String getGrandTotalLocation() {
        return this.handle.getStringProperty("grandTotalLocation");
    }

    public void setGrandTotalLocation(String value) throws SemanticException {
        this.handle.setStringProperty("grandTotalLocation", value);
    }

    public CrosstabCellHandle addGrandTotal(List measureList, List functionList) throws SemanticException {
        return new CrosstabViewTask(this).addGrandTotal(measureList, functionList);
    }

    public void removeGrandTotal() throws SemanticException {
        new CrosstabViewTask(this).removeGrandTotal();
    }

    public void removeGrandTotal(int measureIndex) throws SemanticException {
        new CrosstabViewTask(this).removeGrandTotal(measureIndex);
    }

    public int getAxisType() {
        PropertyHandle propHandle = this.handle.getContainerPropertyHandle();
        if (propHandle == null) {
            return -1;
        }
        String propName = propHandle.getPropertyDefn().getName();
        if ("rows".equals(propName)) {
            return 0;
        }
        if ("columns".equals(propName)) {
            return 1;
        }
        return -1;
    }
}

