/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.impl.GroupBindingColumn;
import org.eclipse.birt.data.engine.impl.ResultIterator;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprMetaUtil;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Scriptable;

class BindingColumnsEvalUtil {
    private IResultIterator odiResult;
    private Scriptable scope;
    private ResultIterator.RDSaveHelper saveHelper;
    private Map<String, BindingColumn> allManualBindingExprs;
    private List allAutoBindingExprs;
    private ScriptContext cx;
    private static final int MANUAL_BINDING = 1;
    private static final int AUTO_BINDING = 2;
    private static Logger logger = Logger.getLogger(BindingColumnsEvalUtil.class.getName());

    BindingColumnsEvalUtil(IResultIterator ri, Scriptable scope, ScriptContext cx, ResultIterator.RDSaveHelper saveUtil, List manualBindingExprs, Map autoBindingExprs) throws DataException {
        Object[] params = new Object[]{ri, scope, saveUtil, manualBindingExprs, autoBindingExprs};
        logger.entering(BindingColumnsEvalUtil.class.getName(), "BindingColumnsEvalUtil", params);
        this.odiResult = ri;
        this.scope = scope;
        this.saveHelper = saveUtil;
        this.cx = cx;
        this.initBindingColumns(manualBindingExprs, autoBindingExprs);
        logger.exiting(BindingColumnsEvalUtil.class.getName(), "BindingColumnsEvalUtil");
    }

    /*
     * WARNING - void declaration
     */
    private void initBindingColumns(List manualBindingExprs, Map autoBindingExprs) throws DataException {
        IBaseExpression baseExpr;
        void var6_8;
        int size = manualBindingExprs.size();
        GroupBindingColumn[] groupBindingColumns = new GroupBindingColumn[size];
        Iterator<Object> itr = manualBindingExprs.iterator();
        while (itr.hasNext()) {
            GroupBindingColumn groupBindingColumn;
            groupBindingColumns[groupBindingColumn.getGroupLevel()] = groupBindingColumn = (GroupBindingColumn)itr.next();
        }
        this.allManualBindingExprs = new HashMap<String, BindingColumn>();
        boolean bl = false;
        while (var6_8 < size) {
            new ArrayList();
            for (String exprName : groupBindingColumns[var6_8].getColumnNames()) {
                baseExpr = groupBindingColumns[var6_8].getExpression(exprName);
                this.allManualBindingExprs.put(exprName, new BindingColumn(exprName, baseExpr, groupBindingColumns[var6_8].getBinding(exprName).getAggrFunction() != null, groupBindingColumns[var6_8].getBinding(exprName).getDataType()));
            }
            ++var6_8;
        }
        this.allAutoBindingExprs = new ArrayList();
        for (Map.Entry entry : autoBindingExprs.entrySet()) {
            String exprName;
            exprName = (String)entry.getKey();
            baseExpr = (IBaseExpression)entry.getValue();
            this.allAutoBindingExprs.add(new BindingColumn(exprName, baseExpr, false, baseExpr.getDataType()));
        }
    }

    void getColumnsValue(Map valueMap, boolean includeAggregation) throws DataException {
        for (BindingColumn bindingColumn : this.allAutoBindingExprs) {
            if (valueMap.containsKey(bindingColumn.columnName)) continue;
            Object exprValue = this.evaluateValue(bindingColumn, 2);
            if (valueMap.get(bindingColumn.columnName) != null) continue;
            valueMap.put(bindingColumn.columnName, exprValue);
        }
        for (BindingColumn bindingColumn : this.allManualBindingExprs.values()) {
            if (valueMap.containsKey(bindingColumn.columnName) || bindingColumn.isAggregation && !includeAggregation) continue;
            Object exprValue = this.evaluateValue(bindingColumn, 1);
            valueMap.put(bindingColumn.columnName, exprValue);
        }
        if (ExprMetaUtil.isBasedOnRD(this.odiResult.getResultClass()) && !this.saveHelper.isSummaryQuery()) {
            if (this.odiResult.getCurrentResult() != null) {
                valueMap.put("_$$_dte_inner_row_id_$$_", this.odiResult.getCurrentResult().getFieldValue("_$$_dte_inner_row_id_$$_"));
            } else {
                valueMap.put("_$$_dte_inner_row_id_$$_", 0);
            }
        }
        this.saveHelper.doSaveExpr(valueMap);
    }

    private Object evaluateValue(BindingColumn bindingColumn, int exprType) throws DataException {
        Object exprValue = null;
        try {
            exprValue = exprType == 1 ? (bindingColumn.isAggregation ? this.odiResult.getAggrValue(bindingColumn.columnName) : ExprEvaluateUtil.evaluateExpression(bindingColumn.baseExpr, this.odiResult, this.scope, this.cx)) : ExprEvaluateUtil.evaluateRawExpression(bindingColumn.baseExpr, this.scope, this.cx);
            if (exprValue != null && !(exprValue instanceof Exception)) {
                exprValue = DataTypeUtil.convert((Object)JavascriptEvalUtil.convertJavascriptValue((Object)exprValue), (int)bindingColumn.type);
            }
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
        return exprValue;
    }

    Object evaluateValue(String bindingName) throws DataException {
        BindingColumn binding = this.getBindingFromManualBinding(bindingName);
        if (binding == null) {
            throw new DataException("data.engine.InvalidBoundColumnName", bindingName);
        }
        return this.evaluateValue(binding, 1);
    }

    private BindingColumn getBindingFromManualBinding(String name) throws DataException {
        return this.allManualBindingExprs.get(name);
    }

    boolean isValidBindingName(String name) throws DataException {
        return this.getBindingFromManualBinding(name) != null;
    }

    private static class BindingColumn {
        private String columnName;
        private IBaseExpression baseExpr;
        private boolean isAggregation;
        private int type;

        private BindingColumn(String columnName, IBaseExpression baseExpr, boolean isAggregation, int type) {
            this.columnName = columnName;
            this.baseExpr = baseExpr;
            this.isAggregation = isAggregation;
            this.type = type;
        }
    }
}

