/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.olap.OLAPException;
import org.eclipse.birt.data.engine.olap.cursor.INavigator;
import org.eclipse.birt.data.engine.olap.cursor.IRowDataAccessor;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.driver.IEdgeAxis;

class EdgeNavigator
implements INavigator {
    private IRowDataAccessor dataAccessor;
    private IAggregationResultSet rs;
    private List warnings;

    EdgeNavigator(IEdgeAxis axis) {
        this.dataAccessor = axis.getRowDataAccessor();
        this.rs = axis.getQueryResultSet();
    }

    public void afterLast() throws OLAPException {
        this.dataAccessor.edge_afterLast();
    }

    public void beforeFirst() throws OLAPException {
        this.dataAccessor.edge_beforeFirst();
    }

    public void close() throws OLAPException {
        try {
            this.rs.close();
        }
        catch (IOException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
    }

    public boolean first() throws OLAPException {
        return this.dataAccessor.edge_first();
    }

    public long getExtend() {
        return 0L;
    }

    public long getPosition() throws OLAPException {
        return this.dataAccessor.getEdgePostion();
    }

    public int getType() {
        return 0;
    }

    public boolean isAfterLast() throws OLAPException {
        return this.dataAccessor.edge_isAfterLast();
    }

    public boolean isBeforeFirst() {
        return this.dataAccessor.edge_isBeforeFirst();
    }

    public boolean isFirst() throws OLAPException {
        return this.dataAccessor.edge_isFirst();
    }

    public boolean isLast() throws OLAPException {
        return this.dataAccessor.edge_isLast();
    }

    public boolean last() throws OLAPException {
        return this.dataAccessor.edge_last();
    }

    public boolean next() throws OLAPException {
        return this.dataAccessor.edge_next();
    }

    public boolean previous() throws OLAPException {
        return this.dataAccessor.edge_previous();
    }

    public boolean relative(int arg0) throws OLAPException {
        return this.dataAccessor.edge_relative(arg0);
    }

    public void setPosition(long position) throws OLAPException {
        this.dataAccessor.edge_setPostion(position);
    }

    public void clearWarnings() throws OLAPException {
        if (this.warnings != null) {
            this.warnings.clear();
        }
    }

    public Collection getWarnings() throws OLAPException {
        return this.warnings == null ? new ArrayList() : this.warnings;
    }

    public void synchronizedPages(int position) {
        this.dataAccessor.sychronizedWithPage(position);
    }
}

