/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.dimension;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.data.api.IDimensionFilterDefn;
import org.eclipse.birt.data.engine.olap.data.api.IDimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.api.IDimensionSortDefn;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.TimeDimensionUtil;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionRow;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

public class DimensionResultIterator
implements IDimensionResultIterator {
    private Dimension dimension;
    private IDiskArray dimensionPosition;
    private IDiskArray dimensionRows;
    private int currentPosition;
    private ILevel[] levels;
    private static Logger logger = Logger.getLogger(DimensionResultIterator.class.getName());
    private int[] memoryDimensionPosition;

    public DimensionResultIterator(Dimension dimension, IDiskArray dimensionPosition, StopSign stopSign) throws IOException {
        Object[] params = new Object[]{dimension, dimensionPosition};
        logger.entering(DimensionResultIterator.class.getName(), "DimensionResultIterator", params);
        this.dimension = dimension;
        this.dimensionPosition = dimensionPosition;
        this.levels = dimension.getHierarchy().getLevels();
        this.currentPosition = 0;
        logger.exiting(DimensionResultIterator.class.getName(), "DimensionResultIterator");
    }

    private void initDimensionRows() throws IOException {
        if (this.dimensionRows == null) {
            if (this.dimensionPosition == null) {
                this.dimensionPosition = this.dimension.findAll();
            }
            this.dimensionRows = this.dimension.getDimensionRowByPositions(this.dimensionPosition, new StopSign());
            this.memoryDimensionPosition = new int[this.dimensionPosition.size()];
            int i = 0;
            while (i < this.dimensionPosition.size()) {
                this.memoryDimensionPosition[i] = (Integer)this.dimensionPosition.get(i);
                ++i;
            }
        }
    }

    public void close() throws BirtException, IOException {
        if (this.dimensionPosition != null) {
            this.dimensionPosition.close();
        }
        if (this.dimensionRows != null) {
            this.dimensionRows.close();
        }
    }

    public IDimensionResultIterator filter(IDimensionFilterDefn filterDef) throws BirtException {
        return null;
    }

    public IDimension getDimesion() {
        return this.dimension;
    }

    public int getDimesionPosition() throws BirtException, IOException {
        this.initDimensionRows();
        return (Integer)this.dimensionPosition.get(this.currentPosition);
    }

    public Object getLevelAttribute(int levelIndex, int attributeIndex) throws IOException {
        if (this.dimension.isTime()) {
            return null;
        }
        this.initDimensionRows();
        return ((DimensionRow)this.dimensionRows.get(this.currentPosition)).getMembers()[levelIndex].getAttributes()[attributeIndex];
    }

    public int getLevelAttributeDataType(String levelName, String attributeName) {
        if (this.dimension.isTime()) {
            return -1;
        }
        return this.levels[this.getLevelIndex(levelName)].getAttributeDataType(attributeName);
    }

    public int getLevelAttributeIndex(String levelName, String attributeName) {
        if (this.dimension.isTime()) {
            return -1;
        }
        String[] attributeNames = this.levels[this.getLevelIndex(levelName)].getAttributeNames();
        int i = 0;
        while (i < attributeNames.length) {
            if (attributeNames[i].equals(attributeName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getLevelIndex(String levelName) {
        if (this.dimension.isTime()) {
            return TimeDimensionUtil.getFieldIndex(levelName);
        }
        int i = 0;
        while (i < this.levels.length) {
            if (this.levels[i].getName().equals(levelName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int[] getLevelKeyDataType(String levelName) {
        if (this.dimension.isTime()) {
            return new int[]{2};
        }
        int levelIndex = this.getLevelIndex(levelName);
        if (levelIndex < 0) {
            return null;
        }
        String[] keyNames = this.levels[levelIndex].getKeyNames();
        int[] result = new int[keyNames.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.levels[levelIndex].getKeyDataType(keyNames[i]);
            ++i;
        }
        return result;
    }

    public Object[] getLevelKeyValue(int levelIndex) throws IOException {
        this.initDimensionRows();
        if (this.dimension.isTime()) {
            Date timeValue = this.getCurrentTimeValue();
            return new Object[]{TimeDimensionUtil.getFieldVaule(timeValue, levelIndex)};
        }
        return ((DimensionRow)this.dimensionRows.get(this.currentPosition)).getMembers()[levelIndex].getKeyValues();
    }

    public ILevel[] getLevels() {
        return this.levels;
    }

    public int length() {
        if (this.dimensionPosition == null) {
            return this.dimension.length();
        }
        return this.dimensionPosition.size();
    }

    public void seek(int index) {
        this.currentPosition = index;
    }

    public void sort(IDimensionSortDefn sortDef) throws BirtException {
    }

    public Member getLevelMember(int levelIndex) throws IOException {
        this.initDimensionRows();
        if (this.dimension.isTime()) {
            Date timeValue = this.getCurrentTimeValue();
            Member member = new Member();
            member.setKeyValues(new Object[]{TimeDimensionUtil.getFieldVaule(timeValue, levelIndex)});
            return member;
        }
        return ((DimensionRow)this.dimensionRows.get(this.currentPosition)).getMembers()[levelIndex];
    }

    private Date getCurrentTimeValue() throws IOException {
        Date timeValue = (Date)((DimensionRow)this.dimensionRows.get(this.currentPosition)).getMembers()[0].getKeyValues()[0];
        return timeValue;
    }

    public DimensionRow getDimensionRow() throws IOException {
        this.initDimensionRows();
        return (DimensionRow)this.dimensionRows.get(this.currentPosition);
    }

    public boolean locate(int dimPosition) throws BirtException, IOException {
        int curDimPosition = this.getDimesionPosition();
        if (curDimPosition == dimPosition) {
            return true;
        }
        if (this.memoryDimensionPosition != null) {
            int pos = Arrays.binarySearch(this.memoryDimensionPosition, dimPosition);
            if (pos < 0) {
                return false;
            }
            this.seek(pos);
            return true;
        }
        while (true) {
            if ((curDimPosition = this.getDimesionPosition()) > dimPosition) {
                if (this.currentPosition - 1 < 0) {
                    return false;
                }
                this.seek(this.currentPosition - 1);
                continue;
            }
            if (curDimPosition >= dimPosition) break;
            if (this.currentPosition + 1 >= this.length()) {
                return false;
            }
            this.seek(this.currentPosition + 1);
        }
        return true;
    }
}

