/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.OutputPropertyDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

public class OutputSection
extends Section {
    protected OutputPropertyDescriptor output;
    private int height = -1;
    IDescriptorProvider provider;

    public OutputSection(Composite parent, boolean isFormStyle) {
        super(" ", parent, isFormStyle);
    }

    public void createSection() {
        this.getOutputControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public OutputPropertyDescriptor getOutputControl() {
        return this.output;
    }

    protected OutputPropertyDescriptor getOutputControl(Composite parent) {
        if (this.output == null) {
            this.output = new OutputPropertyDescriptor(true);
            this.output.setDescriptorProvider(this.provider);
            this.output.createControl(parent);
            this.output.getControl().setLayoutData((Object)new GridData(1808));
            this.output.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    OutputSection.this.output = null;
                }
            });
        } else {
            this.checkParent(this.output.getControl(), parent);
        }
        return this.output;
    }

    public void layout() {
        GridData gd = (GridData)this.output.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - this.placeholder;
        if (this.height > -1) {
            gd.heightHint = this.height;
            gd.grabExcessVerticalSpace = false;
            if (this.displayLabel != null) {
                gd = (GridData)this.displayLabel.getLayoutData();
                gd.verticalAlignment = 16;
            }
        }
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void load() {
        if (this.output != null && !this.output.getControl().isDisposed()) {
            this.output.load();
        }
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.output != null) {
            this.output.setDescriptorProvider(provider);
        }
    }

    public void setInput(Object input) {
        assert (input != null);
        this.output.setInput(input);
    }

    public void setHidden(boolean isHidden) {
        if (this.output != null) {
            WidgetUtil.setExcludeGridData(this.output.getControl(), isHidden);
        }
    }

    public void setVisible(boolean isVisable) {
        if (this.output != null) {
            this.output.getControl().setVisible(isVisable);
        }
    }

    public void reset() {
        if (this.output != null && !this.output.getControl().isDisposed()) {
            this.output.reset();
        }
    }
}

