/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class SetConstraintCommand
extends Command {
    private static Logger logger = Logger.getLogger(SetConstraintCommand.class.getName());
    private static final String TRANS_LABEL_SET_CONSTRAINT = Messages.getString("SetConstraintCommand.transLabel.setConstraint");
    private ReportItemHandle model;
    private static final String Command_Label_Resize = Messages.getString("SetConstraintCommand.commandLabel.ResizeCommand");
    private Dimension newSize;

    public SetConstraintCommand() {
        super(Command_Label_Resize);
    }

    public void execute() {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(TRANS_LABEL_SET_CONSTRAINT);
        try {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("SetConstraintCommand >>  Starts. Target: " + DEUtil.getDisplayLabel(this.model) + ",New size: " + this.newSize.width + "," + this.newSize.height);
            }
            if (this.model instanceof TableHandle || this.model instanceof GridHandle) {
                HandleAdapterFactory.getInstance().getTableHandleAdapter(this.model).ajustSize(this.newSize);
            } else if (this.isFixLayout()) {
                DimensionValue value;
                double width = MetricUtility.pixelToPixelInch(this.newSize.width);
                double height = MetricUtility.pixelToPixelInch(this.newSize.height);
                if (width >= 0.0) {
                    value = DimensionUtil.convertTo((double)width, (String)"in", (String)this.getDefaultUnits());
                    this.model.getWidth().setValue((Object)value);
                }
                if (height >= 0.0) {
                    value = DimensionUtil.convertTo((double)height, (String)"in", (String)this.getDefaultUnits());
                    this.model.getHeight().setValue((Object)value);
                }
            } else if (this.model instanceof ImageHandle) {
                DimensionValue dimensionValue;
                int width = this.newSize.width;
                int height = this.newSize.height;
                if (width >= 0) {
                    dimensionValue = new DimensionValue((double)width, "px");
                    this.model.getWidth().setValue((Object)dimensionValue);
                }
                if (height >= 0) {
                    dimensionValue = new DimensionValue((double)height, "px");
                    this.model.getHeight().setValue((Object)dimensionValue);
                }
            } else {
                DimensionValue dimensionValue;
                double width = MetricUtility.pixelToPixelInch(this.newSize.width);
                double height = MetricUtility.pixelToPixelInch(this.newSize.height);
                if (width >= 0.0) {
                    dimensionValue = new DimensionValue(width, "in");
                    this.model.getWidth().setValue((Object)dimensionValue);
                }
                if (height >= 0.0) {
                    dimensionValue = new DimensionValue(height, "in");
                    this.model.getHeight().setValue((Object)dimensionValue);
                }
            }
            stack.commit();
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("SetConstraintCommand >> Finised.");
            }
        }
        catch (SemanticException e) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("SetConstraintCommand >> Failed.");
            }
            logger.log(Level.SEVERE, e.getMessage(), e);
            stack.rollback();
        }
    }

    private boolean isFixLayout() {
        return DEUtil.isFixLayout(this.model);
    }

    private String getDefaultUnits() {
        if (this.model != null) {
            return this.model.getModuleHandle().getDefaultUnits();
        }
        return "in";
    }

    public String getLabel() {
        return Command_Label_Resize;
    }

    public void setConstraint(Rectangle r) {
        this.setSize(r.getSize());
    }

    public void setModel(ReportItemHandle model) {
        this.model = model;
    }

    public void setSize(Dimension p) {
        this.newSize = p;
    }
}

