/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.figures;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Color;

public class EditableLabel
extends Label {
    protected Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private boolean selected;
    private boolean gradientMode;
    Color ForeColor = ColorConstants.lightGreen;

    public EditableLabel(String text) {
        super(text);
    }

    public EditableLabel(String text, boolean gradient) {
        this(text);
        this.gradientMode = gradient;
    }

    private Rectangle getSelectionRectangle() {
        Rectangle bounds = this.getTextBounds().getCopy();
        bounds.expand(new Insets(2, 4, 4, 1));
        this.translateToParent((Translatable)bounds);
        bounds.intersect(this.getBounds());
        return bounds;
    }

    public void setText(String s) {
        super.setText(s);
    }

    public void resetColor(Color c) {
        this.setForegroundColor(c);
        this.repaint();
    }

    public void setGradientMode(boolean b) {
        this.gradientMode = b;
        this.repaint();
    }

    protected void paintFigure(Graphics graphics) {
        if (this.selected) {
            graphics.pushState();
            graphics.setBackgroundColor(ColorConstants.menuBackgroundSelected);
            graphics.fillRectangle(this.getSelectionRectangle());
            graphics.popState();
            graphics.setForegroundColor(ColorConstants.white);
        }
        if (this.gradientMode) {
            graphics.pushState();
            graphics.setForegroundColor(this.ForeColor);
            graphics.fillGradient(this.getBounds(), true);
            graphics.popState();
        } else {
            graphics.fillRectangle(this.getBounds());
        }
        Rectangle bounds = this.getBounds();
        graphics.translate(bounds.x, bounds.y);
        if (this.getIcon() != null) {
            graphics.drawImage(this.getIcon(), this.getIconLocation());
        }
        if (!this.isEnabled()) {
            graphics.translate(1, 1);
            graphics.setForegroundColor(ColorConstants.buttonLightest);
            graphics.drawText(this.getSubStringText(), this.getTextLocation());
            graphics.translate(-1, -1);
            graphics.setForegroundColor(ColorConstants.buttonDarker);
        }
        graphics.drawText(this.getSubStringText(), this.getTextLocation());
        graphics.translate(-bounds.x, -bounds.y);
    }

    public void setSelected(boolean b) {
        this.selected = b;
        this.repaint();
    }
}

