/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.generator;

import hiro.yoshioka.generator.MyFormatter;
import hiro.yoshioka.generator.RandomFormatter;
import hiro.yoshioka.generator.RandomMode;
import hiro.yoshioka.generator.SequenceFormatter;
import hiro.yoshioka.generator.TextFormatter;
import hiro.yoshioka.generator.XXXMode;
import hiro.yoshioka.generator.XxxFormatter;
import hiro.yoshioka.generator.bean.GenerateManagerBean;
import hiro.yoshioka.generator.bean.GeneratorBean;
import hiro.yoshioka.generator.bean.GroupGeneratorBean;
import hiro.yoshioka.generator.formatter.ColumnGenerateFormat;
import hiro.yoshioka.preferences.GenerateType;
import hiro.yoshioka.sdh.BindObject;
import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sql.resource.xml.DBResouceValue;
import hiro.yoshioka.sql.resource.xml.DBTableValue;
import hiro.yoshioka.util.SQLDataType;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class GenerateManager {
    static final String BAR = "-";
    protected Log fLogger = LogFactory.getLog(this.getClass());
    private double databaseVersion;
    private DatabaseType databaseType;
    private GenerateManagerBean bean;

    public GenerateManager(GenerateManagerBean bean) {
        this.bean = bean;
    }

    public GenerateManager(DBTableValue dbTable) {
        this.bean = new GenerateManagerBean(dbTable);
    }

    public GenerateManagerBean getBean() {
        return this.bean;
    }

    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public void setDatabaseVersion(double databaseVersion) {
        this.databaseVersion = databaseVersion;
    }

    public void refreshPreviewOfGroup(Table previewTable, int maxGroupCount) {
        int maxGroupInCount = this.bean.getGrpGenOfCols()[0].getColumnGenerateFormat().getGenerateFormatDefs().length;
        boolean doPack = true;
        previewTable.removeAll();
        TableColumn[] columns = previewTable.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].dispose();
            ++i;
        }
        GroupGeneratorBean[] ggen = this.bean.getGrpGenOfCols();
        int i2 = 0;
        while (i2 < ggen.length) {
            TableColumn column = new TableColumn(previewTable, 0);
            column.setText(ggen[i2].getColumn().getName());
            column.pack();
            ++i2;
        }
        try {
            int totalCounter = 0;
            Date today = new Date();
            int sumGeneratedGroupCount = 0;
            while (sumGeneratedGroupCount < maxGroupCount) {
                int numOfGroupInCounter = 0;
                while (numOfGroupInCounter < maxGroupInCount) {
                    TableItem item = new TableItem(previewTable, 0);
                    String[] strings = new String[ggen.length];
                    int clen = 0;
                    while (clen < ggen.length) {
                        GeneratorBean gen;
                        if (ggen[clen].getGenerateType() == GenerateType.SELECTED_ROWS) {
                            gen = ggen[clen].getGeneratorBean();
                            gen.setGroupInCounter(numOfGroupInCounter);
                            strings[clen] = gen.getFormatterList().get(numOfGroupInCounter).formatedString(sumGeneratedGroupCount, numOfGroupInCounter, totalCounter, today);
                        } else {
                            gen = ggen[clen].getGeneratorBean();
                            gen.setGroupInCounter(numOfGroupInCounter);
                            strings[clen] = gen.getFormatterList().get(0).formatedString(sumGeneratedGroupCount, numOfGroupInCounter, totalCounter, today);
                        }
                        ++clen;
                    }
                    item.setText(strings);
                    if (numOfGroupInCounter % 2 == 0) {
                        item.setBackground(ColorConstants.lightGray);
                    }
                    if (numOfGroupInCounter == 0) {
                        item.setBackground(ColorConstants.lightBlue);
                    }
                    ++totalCounter;
                    ++numOfGroupInCounter;
                }
                if (doPack) {
                    int i3 = 0;
                    while (i3 < ggen.length) {
                        TableColumn column = previewTable.getColumn(i3);
                        column.pack();
                        ++i3;
                    }
                    doPack = false;
                }
                ++sumGeneratedGroupCount;
            }
        }
        catch (Throwable e) {
            this.fLogger.warn((Object)e);
            e.printStackTrace();
        }
    }

    public void refreshPreviewSimple(Table table, int maxGenerateCount) {
        boolean doPack = true;
        table.removeAll();
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].dispose();
            ++i;
        }
        GroupGeneratorBean[] ggen = this.bean.getGrpGenOfCols();
        int i2 = 0;
        while (i2 < ggen.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(ggen[i2].getColumn().getName());
            column.pack();
            ++i2;
        }
        Date today = new Date();
        int i3 = 0;
        while (i3 < maxGenerateCount) {
            TableItem item = new TableItem(table, 0);
            String[] strings = new String[ggen.length];
            int j = 0;
            while (j < ggen.length) {
                GeneratorBean gen = ggen[j].getGeneratorBean();
                strings[j] = gen.getFormatterList().get(0).formatedString(0, 0, i3, today);
                ++j;
            }
            item.setText(strings);
            if (i3 % 2 == 0) {
                item.setBackground(ColorConstants.lightGray);
            }
            if (doPack) {
                j = 0;
                while (j < ggen.length) {
                    TableColumn column = table.getColumn(j);
                    column.pack();
                    ++j;
                }
                doPack = false;
            }
            ++i3;
        }
    }

    public List<Map<String, BindObject>> createInsertValuesMap(Table table) {
        ArrayList<Map<String, BindObject>> retList = new ArrayList<Map<String, BindObject>>();
        TableItem[] items = table.getItems();
        GroupGeneratorBean[] ggen = this.bean.getGrpGenOfCols();
        int i = 0;
        while (i < items.length) {
            LinkedHashMap<String, BindObject> map = new LinkedHashMap<String, BindObject>();
            int j = 0;
            while (j < ggen.length) {
                String value = items[i].getText(j);
                SQLDataType dataType = ggen[j].getColumn().getType();
                String key = ggen[j].getColumn().getName();
                BindObject bi = new BindObject(value, dataType);
                map.put(key, bi);
                ++j;
            }
            retList.add(map);
            ++i;
        }
        return retList;
    }

    public String createScript(Table table) {
        StringBuilder buf = new StringBuilder();
        StringBuilder buf2 = new StringBuilder();
        DBResouceValue parent = this.bean.getDbTable().getParent();
        String tname = "";
        if (!StringUtil.isEmpty((Object)parent.getName())) {
            tname = String.valueOf(parent.getName()) + ".";
        }
        tname = String.valueOf(tname) + this.bean.getDbTable().getName();
        buf2.append("INSERT INTO ").append(tname).append(" (");
        GroupGeneratorBean[] ggen = this.bean.getGrpGenOfCols();
        int i = 0;
        while (i < ggen.length) {
            if (i > 0) {
                buf2.append(",");
            }
            buf2.append(ggen[i].getColumn().getName());
            ++i;
        }
        buf2.append(") ").append(StringUtil.LINE_SEPARATOR).append(" VALUES (");
        TableItem[] items = table.getItems();
        int i2 = 0;
        while (i2 < items.length) {
            buf.append((CharSequence)buf2);
            int j = 0;
            while (j < ggen.length) {
                if (j > 0) {
                    buf.append(",");
                }
                String value = items[i2].getText(j);
                SQLDataType dataType = ggen[j].getColumn().getType();
                if (dataType.isString() || dataType.isDateOrDateTimeOrTime()) {
                    buf.append("'").append(value).append("'");
                } else if (StringUtil.isEmpty((Object)value)) {
                    buf.append("NULL");
                } else {
                    buf.append(value);
                }
                ++j;
            }
            buf.append("); ").append(StringUtil.LINE_SEPARATOR);
            ++i2;
        }
        if (buf.length() > 0 && DatabaseType.ORACLE.equals((Object)this.databaseType) && this.databaseVersion > 9.0) {
            buf.insert(0, "ALTER SESSION SET NLS_TIMESTAMP_FORMAT='yyyy-mm-dd hh24:mi:ss.ff';" + StringUtil.LINE_SEPARATOR);
            buf.insert(0, "ALTER SESSION SET NLS_DATE_FORMAT='yyyy-mm-dd';" + StringUtil.LINE_SEPARATOR);
        }
        return buf.toString();
    }

    public void setAllSeqGenerator(int initValue, boolean zeroFilled) {
        this.bean.setAllType(GenerateType.SEQUENCE);
        GroupGeneratorBean[] ggen = this.bean.getGrpGenOfCols();
        int j = 0;
        while (j < ggen.length) {
            ggen[j].setStartValue(initValue);
            MyFormatter gen = ggen[j].resetGenerateType(GenerateType.SEQUENCE);
            ((SequenceFormatter)gen).setZeroFilled(zeroFilled);
            ++j;
        }
    }

    public void setAllRandomGenerator(RandomMode mode, boolean zeroFilled) {
        this.bean.setAllType(GenerateType.RANDOM);
        GroupGeneratorBean[] ggen = this.bean.getGrpGenOfCols();
        int j = 0;
        while (j < ggen.length) {
            MyFormatter gen = ggen[j].resetGenerateType(GenerateType.RANDOM);
            if (ggen[j].getColumn().getType().isNumerics()) {
                ((RandomFormatter)gen).resetMode(RandomMode.DIGITAL, zeroFilled);
            } else {
                ((RandomFormatter)gen).resetMode(mode, zeroFilled);
            }
            ++j;
        }
    }

    public void setAllXxxGenerator(XXXMode mode) {
        this.bean.setAllType(GenerateType.XXX);
        GroupGeneratorBean[] ggen = this.bean.getGrpGenOfCols();
        try {
            int j = 0;
            while (j < ggen.length) {
                MyFormatter gen = ggen[j].resetGenerateType(GenerateType.XXX);
                ((XxxFormatter)gen).resetMode(mode);
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPartOfSeqGenerator(int initValue, boolean zeroFilled, int columnIdx) {
        GroupGeneratorBean[] ggen = this.bean.getGrpGenOfCols();
        ggen[columnIdx].setStartValue(initValue);
        MyFormatter gen = ggen[columnIdx].resetGenerateType(GenerateType.SEQUENCE);
        ((SequenceFormatter)gen).setZeroFilled(zeroFilled);
    }

    public void setPartOfRandomGenerator(RandomMode mode, boolean zeroFilled, int columnIdx) {
        GroupGeneratorBean[] ggen = this.bean.getGrpGenOfCols();
        MyFormatter gen = ggen[columnIdx].resetGenerateType(GenerateType.RANDOM);
        if (ggen[columnIdx].getColumn().getType().isNumerics()) {
            ((RandomFormatter)gen).resetMode(RandomMode.DIGITAL, zeroFilled);
        } else {
            ((RandomFormatter)gen).resetMode(mode, zeroFilled);
        }
    }

    public void setPartOfXxxGenerator(XXXMode mode, int columnIdx) {
        GroupGeneratorBean[] ggen = this.bean.getGrpGenOfCols();
        MyFormatter gen = ggen[columnIdx].resetGenerateType(GenerateType.XXX);
        ((XxxFormatter)gen).resetMode(mode);
    }

    public int getPartOfStartValue(int columnIdx) {
        GroupGeneratorBean[] ggen = this.bean.getGrpGenOfCols();
        return ggen[columnIdx].getStartValue();
    }

    public void setPartOfTextGenerator(boolean sequencial, boolean splitted, String filePath, int columnIdx) {
        GroupGeneratorBean[] ggen = this.bean.getGrpGenOfCols();
        if (!ggen[columnIdx].getColumn().getType().isString()) {
            Application.openDialog("Error", "This column type is not String", 1);
            return;
        }
        MyFormatter gen = ggen[columnIdx].resetGenerateType(GenerateType.TEXT_FILE);
        TextFormatter tg = (TextFormatter)gen;
        tg.setFilePath(filePath);
        tg.setSequencial(sequencial);
        tg.setSplitted(splitted);
    }

    public void setGenerator(GenerateType type) {
        this.bean.setAllType(type);
        GroupGeneratorBean[] ggen = this.bean.getGrpGenOfCols();
        int j = 0;
        while (j < ggen.length) {
            ggen[j].resetGenerateType(type);
            ++j;
        }
    }

    public void setPartGenerator(GenerateType type, int columnIdx) {
        GroupGeneratorBean[] ggen = this.bean.getGrpGenOfCols();
        ggen[columnIdx].resetGenerateType(type);
    }

    public ColumnGenerateFormat getColumnGenerateFormat(int columnIdx) {
        GroupGeneratorBean[] ggen = this.bean.getGrpGenOfCols();
        return ggen[columnIdx].getColumnGenerateFormat();
    }

    public void setGenerator(GenerateType type, ColumnGenerateFormat[] formats) {
        this.bean.setAllType(type);
        GroupGeneratorBean[] ggen = this.bean.getGrpGenOfCols();
        int j = 0;
        while (j < ggen.length) {
            ggen[j].resetGenerateType(type, formats[j]);
            ++j;
        }
    }

    public void setPartGenerator(GenerateType type, int columnIdx, ColumnGenerateFormat formats) {
        GroupGeneratorBean[] ggen = this.bean.getGrpGenOfCols();
        ggen[columnIdx].resetGenerateType(type, formats);
    }

    public Object[] getElements() {
        GroupGeneratorBean[] ggen = this.bean.getGrpGenOfCols();
        ArrayList<String[]> retList = new ArrayList<String[]>();
        retList.add(new String[]{"ALL", BAR, this.bean.getAllType().getMessage(), BAR, BAR});
        int i = 0;
        while (i < ggen.length) {
            retList.add(new String[]{ggen[i].getColumnName(), "" + ggen[i].getColumn().getSize(), ggen[i].getGenerateType().getMessage(), ggen[i].getFormatDefinition(), ggen[i].getExtraFormatDefinition()});
            ++i;
        }
        return retList.toArray((T[])new String[retList.size()][]);
    }
}

