/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import hiro.yoshioka.ast.sql.util.ASTFormatingInfo;
import hiro.yoshioka.ast.sql.util.ParserFactory;
import hiro.yoshioka.ast.sql.util.ParserUtil;
import hiro.yoshioka.preferences.Messages;
import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.util.StringUtil;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class FormatPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    static final String[] ITEMS = new String[]{Messages.FormatPreferencePage_0, Messages.FormatPreferencePage_1};
    Spinner fIndentSize;
    Font font;
    Spinner fColumnNum;
    Label columnNumLabel;
    Text fSampleSQL;
    Text fBeforeSQL;
    Combo cf;
    Button fIndentTabButton;
    Button fDecodeTabButton;
    Button fLeaveColumnCommentButton;
    Button fBlankButton;
    Button fLeftButton;
    Combo col_mode;
    static final String[] SQL_ITEMS = new String[]{"SELECT0", "SELECT1", "SELECT2", "SELECT3", "CREATE0", "INSERT", "UPDATE"};
    static final String create00 = " -- HR Schema County table reffrences Regions                                    " + StringUtil.LINE_SEPARATOR + "   CREATE TABLE HR.COUNTRIES                                                     " + StringUtil.LINE_SEPARATOR + "    (\t                                                                           " + StringUtil.LINE_SEPARATOR + "    COUNTRY_ID CHAR(2) CONSTRAINT COUNTRY_ID_NN NOT NULL ENABLE,                 " + StringUtil.LINE_SEPARATOR + "    COUNTRY_NAME VARCHAR2(40), -- NULLABLE                                       " + StringUtil.LINE_SEPARATOR + "  REGION_ID NUMBER,  -- NULLABLE                                                 " + StringUtil.LINE_SEPARATOR + "   CONSTRAINT COUNTRY_C_ID_PK PRIMARY KEY (COUNTRY_ID) ENABLE,                   " + StringUtil.LINE_SEPARATOR + "  CONSTRAINT COUNTR_REG_FK FOREIGN KEY (REGION_ID)                              " + StringUtil.LINE_SEPARATOR + "    REFERENCES HR.REGIONS (REGION_ID) ENABLE                                     " + StringUtil.LINE_SEPARATOR + "    ) ORGANIZATION INDEX NOCOMPRESS PCTFREE 10 INITRANS 2 MAXTRANS 255 LOGGING   " + StringUtil.LINE_SEPARATOR + "   STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645         " + StringUtil.LINE_SEPARATOR + "   PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT)              " + StringUtil.LINE_SEPARATOR + "   TABLESPACE USERS                                                              " + StringUtil.LINE_SEPARATOR + "  PCTTHRESHOLD 50                                                                " + StringUtil.LINE_SEPARATOR + "                                                                                 " + StringUtil.LINE_SEPARATOR + "                                                                                 ";
    static final String sample00 = " -- test sql " + StringUtil.LINE_SEPARATOR + " -- line 2 " + StringUtil.LINE_SEPARATOR + " /* multi line " + StringUtil.LINE_SEPARATOR + "  * multi comments \r\n" + "  */  \r\n\r\n" + " SELECT\r\n  country_id AS cid                       " + "  ,bbbb AS secondColumn  -- id2 \r\n" + "  ,cccc,  -- id3  \r\n" + "  d  -- id4\r\n\r\n" + "  FROM countries                   ";
    static final String sample = "SELECT\r\n column1,col2,column3,column4,column5,col6\r\n,long_long_name_column ,column8, column9 \r\nc10 from myTable  WHERE colum1 = '3' \r\nand column4!=5 or (column5  != column6) order by 1,2 \r\ndesc ,3,4,5";
    static final String sample2 = "SELECT\r\n * FROM\r\n ( SELECT    JOB,MGR,R FROM   (     SELECT        EMPNO, ENAME,        JOB, MGR,        HIREDATE, SAL,        COMM, DEPTNO,        dense_rank()             over (order by             MGR desc) R   \r\n  FROM       EMP   )   WHERE\r\n R=1 ) ";
    static final String sample3 = "SELECT \r\nDECODE(JOB,NULL,'***',JOB) JOB, 'This is a title' AS TITLE, \r\nDECODE(DEPTNO,NULL          ,'***',             DEPTNO      ) DEPTNO, SUM(SAL) SAL, GROUPING_ID(JOB,DEPTNO) AS GID FROM EMP GROUP BY ROLLUP(JOB,MGR) ";
    static final String insert = "INSERT INTO EMP \r\n(EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO)   \r\nVALUES(1,\"TOM\",\"SALES\",123,'2007-03-31',240000,12,45 ) ";
    static final String update = "UPDATE\r\n EMP SET JOB=3,ENAME='hoge' \r\nWHERE EMPNO IN (SELECT EMPNO FROM DEPTO) ";
    static final String[] SQL_STATEMENTS = new String[]{sample00, "SELECT\r\n column1,col2,column3,column4,column5,col6\r\n,long_long_name_column ,column8, column9 \r\nc10 from myTable  WHERE colum1 = '3' \r\nand column4!=5 or (column5  != column6) order by 1,2 \r\ndesc ,3,4,5", "SELECT\r\n * FROM\r\n ( SELECT    JOB,MGR,R FROM   (     SELECT        EMPNO, ENAME,        JOB, MGR,        HIREDATE, SAL,        COMM, DEPTNO,        dense_rank()             over (order by             MGR desc) R   \r\n  FROM       EMP   )   WHERE\r\n R=1 ) ", "SELECT \r\nDECODE(JOB,NULL,'***',JOB) JOB, 'This is a title' AS TITLE, \r\nDECODE(DEPTNO,NULL          ,'***',             DEPTNO      ) DEPTNO, SUM(SAL) SAL, GROUPING_ID(JOB,DEPTNO) AS GID FROM EMP GROUP BY ROLLUP(JOB,MGR) ", create00, "INSERT INTO EMP \r\n(EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO)   \r\nVALUES(1,\"TOM\",\"SALES\",123,'2007-03-31',240000,12,45 ) ", "UPDATE\r\n EMP SET JOB=3,ENAME='hoge' \r\nWHERE EMPNO IN (SELECT EMPNO FROM DEPTO) "};

    public void dispose() {
        super.dispose();
        try {
            if (this.font != null && !this.font.isDisposed()) {
                this.font.dispose();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FormatPreferencePage() {
        this.setTitle(Messages.FormatPreferencePage_53);
        this.setMessage(Messages.FormatPreferencePage_54);
    }

    private void refresh() {
        if (this.fDecodeTabButton.getSelection() || this.fLeaveColumnCommentButton.getSelection()) {
            this.fColumnNum.setEnabled(false);
            this.columnNumLabel.setForeground(ColorConstants.gray);
        } else {
            this.columnNumLabel.setForeground(ColorConstants.black);
            this.fColumnNum.setEnabled(true);
        }
        this.format();
    }

    private void format() {
        String targetString = SQL_STATEMENTS[this.cf.getSelectionIndex()];
        ParserFactory factory = ParserFactory.createFactory((String)DatabaseType.ORACLE.getDriverName());
        ParserUtil util = factory.createParserUtil(targetString);
        ASTFormatingInfo info = new ASTFormatingInfo(targetString);
        info.setIndentInfo(this.fIndentTabButton.getSelection(), this.fIndentSize.getSelection());
        info.col_num = this.fColumnNum.getSelection();
        info.setSelectColumnCommentOn(this.fLeaveColumnCommentButton.getSelection());
        info.setContinuingBlank2aBlank(this.fBlankButton.getSelection());
        info.setExpandDecode(this.fDecodeTabButton.getSelection());
        info.left = this.fLeftButton.getSelection();
        info.max_col_len = 180;
        info.mode = this.col_mode.getSelectionIndex() + 1;
        info.fSQLStatement = targetString;
        util.parse();
        this.fBeforeSQL.setText(targetString);
        this.fSampleSQL.setText(util.getFormattedString(info));
    }

    protected Control createContents(Composite parent) {
        try {
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            ScrolledForm root = toolkit.createScrolledForm(parent);
            root.setText("SQL STATEMENT FORMAT Settings");
            root.getBody().setLayout((Layout)new GridLayout());
            Section section = toolkit.createSection(root.getBody(), 320);
            section.setText("Parameters");
            Composite inner = toolkit.createComposite((Composite)section);
            inner.setLayout((Layout)new GridLayout(6, false));
            toolkit.createLabel(inner, Messages.FormatPreferencePage_52);
            toolkit.createLabel(inner, ":");
            this.fIndentTabButton = toolkit.createButton(inner, "", 32);
            this.fIndentTabButton.setSelection(PreferenceUtil.getBoolean("BOOLEAN_INDENT_BY_TAB"));
            this.fIndentTabButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FormatPreferencePage.this.fIndentSize.setEnabled(!FormatPreferencePage.this.fIndentTabButton.getSelection());
                }
            });
            this.fIndentTabButton.addSelectionListener((SelectionListener)this);
            toolkit.createLabel(inner, Messages.FormatPreferencePage_39);
            toolkit.createLabel(inner, ":");
            this.fIndentSize = new Spinner(inner, 72);
            this.fIndentSize.setCapture(false);
            this.fIndentSize.setValues(PreferenceUtil.getInt("INDENT_NUM"), 1, 8, 0, 1, 4);
            this.fIndentSize.setEnabled(!this.fIndentTabButton.getSelection());
            this.fIndentSize.addSelectionListener((SelectionListener)this);
            toolkit.createLabel(inner, "ContinuingBlank2Blank");
            toolkit.createLabel(inner, ":");
            this.fBlankButton = toolkit.createButton(inner, "", 32);
            this.fBlankButton.setSelection(PreferenceUtil.getBoolean("BOOLEAN_CONTINUING_BLANK_2_BLANK"));
            this.fBlankButton.addSelectionListener((SelectionListener)this);
            toolkit.createLabel(inner, Messages.FormatPreferencePage_44);
            toolkit.createLabel(inner, ":");
            this.col_mode = new Combo(inner, 12);
            this.col_mode.setItems(ITEMS);
            this.col_mode.select(PreferenceUtil.getInt("COLUMN_MODE"));
            this.col_mode.addSelectionListener((SelectionListener)this);
            this.columnNumLabel = toolkit.createLabel(inner, Messages.FormatPreferencePage_46);
            toolkit.createLabel(inner, ":");
            this.fColumnNum = new Spinner(inner, 72);
            this.fColumnNum.setCapture(false);
            this.fColumnNum.setValues(PreferenceUtil.getInt("COLUMN_NUM"), 1, 30, 0, 1, 4);
            this.fColumnNum.addSelectionListener((SelectionListener)this);
            toolkit.createLabel(inner, Messages.FormatPreferencePage_48);
            toolkit.createLabel(inner, ":");
            this.fLeftButton = toolkit.createButton(inner, "", 32);
            this.fLeftButton.setSelection(PreferenceUtil.getBoolean("BOOLEAN_ALIGHN_LEFT"));
            this.fLeftButton.addSelectionListener((SelectionListener)this);
            toolkit.createLabel(inner, Messages.FormatPreferencePage_41);
            toolkit.createLabel(inner, ":");
            this.fDecodeTabButton = toolkit.createButton(inner, "", 32);
            this.fDecodeTabButton.setSelection(PreferenceUtil.getBoolean("BOOLEAN_INDENT_BY_TAB"));
            this.fDecodeTabButton.addSelectionListener((SelectionListener)this);
            toolkit.createLabel(inner, "Leave column comments");
            toolkit.createLabel(inner, ":");
            this.fLeaveColumnCommentButton = toolkit.createButton(inner, "", 32);
            this.fLeaveColumnCommentButton.setSelection(PreferenceUtil.getBoolean("BOOLEAN_LEAVE_COLUMN_COMMENT"));
            this.fLeaveColumnCommentButton.addSelectionListener((SelectionListener)this);
            section.setClient((Control)inner);
            section.setLayoutData((Object)new GridData(768));
            Section section2 = toolkit.createSection(root.getBody(), 320);
            section2.setText(Messages.FormatPreferencePage_51);
            Composite inner2 = toolkit.createComposite((Composite)section2);
            inner2.setLayout((Layout)new GridLayout(1, true));
            this.cf = new Combo(inner2, 12);
            this.cf.setItems(SQL_ITEMS);
            this.cf.select(0);
            this.cf.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FormatPreferencePage.this.fSampleSQL.setText(SQL_STATEMENTS[FormatPreferencePage.this.cf.getSelectionIndex()]);
                    FormatPreferencePage.this.format();
                }
            });
            this.cf.setLayoutData((Object)new GridData(768));
            SashForm sash = new SashForm(inner2, 256);
            this.fBeforeSQL = new Text((Composite)sash, 2818);
            this.fBeforeSQL.setLayoutData((Object)new FillLayout());
            this.fBeforeSQL.setSize(200, 200);
            this.fSampleSQL = new Text((Composite)sash, 2818);
            this.fSampleSQL.setLayoutData((Object)new FillLayout());
            sash.setWeights(new int[]{60, 40});
            sash.setLayoutData((Object)new GridData(1808));
            this.font = new Font((Device)this.fSampleSQL.getDisplay(), "Lucida Sans Typewriter", 9, 0);
            this.fBeforeSQL.setFont(this.font);
            this.fSampleSQL.setFont(this.font);
            this.refresh();
            section2.setClient((Control)inner2);
            section2.setLayoutData((Object)new GridData(1808));
            return root;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void performApply() {
        PreferenceUtil.setBoolean("BOOLEAN_INDENT_BY_TAB", this.fIndentTabButton.getSelection());
        PreferenceUtil.setBoolean("BOOLEAN_ALIGHN_LEFT", this.fLeftButton.getSelection());
        PreferenceUtil.setBoolean("BOOLEAN_DECODE_CARE", this.fDecodeTabButton.getSelection());
        PreferenceUtil.setBoolean("BOOLEAN_CONTINUING_BLANK_2_BLANK", this.fBlankButton.getSelection());
        PreferenceUtil.setInt("COLUMN_NUM", this.fColumnNum.getSelection());
        PreferenceUtil.setInt("INDENT_NUM", this.fIndentSize.getSelection());
        PreferenceUtil.setInt("COLUMN_MODE", this.col_mode.getSelectionIndex());
        PreferenceUtil.setBoolean("BOOLEAN_LEAVE_COLUMN_COMMENT", this.fLeaveColumnCommentButton.getSelection());
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    public void init(IWorkbench workbench) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.refresh();
    }
}

