/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.selenium;

import hiro.yoshioka.selenium.Messages;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Macro {
    private static final List<String> macroList = new ArrayList<String>();
    private static final Pattern P;

    static {
        macroList.add("yyyymm");
        macroList.add("yyyymmdd");
        macroList.add("yyyymmddHHMM");
        macroList.add("yyyymmddHHMMss");
        macroList.add("HHMMss");
        macroList.add("HHMM");
        macroList.add("user_name");
        macroList.add("today");
        macroList.add("now");
        macroList.add(Messages.Macro_EnterString);
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < macroList.size()) {
            if (i > 0) {
                buf.append("|");
            }
            buf.append("(").append(macroList.get(i)).append(")");
            ++i;
        }
        P = Pattern.compile("[$][{](" + buf.toString() + ")[}]");
    }

    public static String replace(String macro, Date d) {
        Matcher m = P.matcher(macro);
        StringBuffer buf = new StringBuffer();
        while (m.find()) {
            if (m.group(2) != null) {
                m.appendReplacement(buf, String.format("%tY%tm", d, d));
                continue;
            }
            if (m.group(3) != null) {
                m.appendReplacement(buf, String.format("%tY%tm%td", d, d, d));
                continue;
            }
            if (m.group(4) != null) {
                m.appendReplacement(buf, String.format("%tY%tm%td%tH%tM", d, d, d, d, d));
                continue;
            }
            if (m.group(5) != null) {
                m.appendReplacement(buf, String.format("%tY%tm%td%tH%tM%ts", d, d, d, d, d, d));
                continue;
            }
            if (m.group(6) != null) {
                m.appendReplacement(buf, String.format("%tH%tM%ts", d, d, d));
                continue;
            }
            if (m.group(7) != null) {
                m.appendReplacement(buf, String.format("%tH%tM", d, d));
                continue;
            }
            if (m.group(8) != null) {
                m.appendReplacement(buf, System.getProperty("user.name"));
                continue;
            }
            if (m.group(9) != null) {
                m.appendReplacement(buf, String.format("%tY-%tm-%td", d, d, d));
                continue;
            }
            if (m.group(10) != null) {
                m.appendReplacement(buf, String.format("%tY-%tm-%td %tH:%tM:%ts", d, d, d, d, d, d));
                continue;
            }
            if (m.group(11) == null) continue;
            m.appendReplacement(buf, "\n");
        }
        m.appendTail(buf);
        return buf.toString();
    }
}

