/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.vaction;

import hiro.yoshioka.gef.editor.SchemaDiagramEditor;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.util.ConnectionSettingDialog;
import hiro.yoshioka.vaction.Messages;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;

public class NewEditorDropDownAction
extends Action {
    String fExtention;
    boolean isScrap;
    ConnectionProperties connectionProperties;

    public NewEditorDropDownAction(String extention, String title, ImageDescriptor imgPath, boolean scrap) {
        super(String.valueOf(Messages.getString("NewEditorDropDownAction.New")) + title + Messages.getString("NewEditorDropDownAction.ScrachEditorWithoutSave"), 1);
        this.isScrap = scrap;
        if (this.isScrap) {
            this.setText(String.valueOf(Messages.getString("NewEditorDropDownAction.New")) + title + Messages.getString("NewEditorDropDownAction.ScrachEditorWithoutSave"));
        } else {
            this.setText(String.valueOf(Messages.getString("NewEditorDropDownAction.New")) + title + Messages.getString("NewEditorDropDownAction.EditorWithName"));
        }
        this.setImageDescriptor(imgPath);
        this.fExtention = extention;
    }

    private String openNameDialog() {
        InputDialog dlg = new InputDialog(Display.getDefault().getActiveShell(), Messages.getString("NewEditorDropDownAction.InputFileName"), Messages.getString("NewEditorDropDownAction.MeansScrach"), "", null);
        if (dlg.open() == 0) {
            return dlg.getValue();
        }
        return null;
    }

    private IFile createRandomFile(IFolder folder) {
        return ResourceMarker.createRandomFile(folder, this.fExtention);
    }

    private void doOpenEditor(String name) {
        IFolder folder = null;
        folder = this.fExtention.equals(ResourceMarker.sqlFolder) ? ResourceMarker.getFolder(null, ResourceMarker.sqlFolder) : (this.fExtention.equals(ResourceMarker.lstFolder) ? ResourceMarker.getFolder(null, ResourceMarker.lstFolder) : (this.fExtention.equals(ResourceMarker.yamlFolder) ? ResourceMarker.getFolder(null, ResourceMarker.yamlFolder) : ResourceMarker.getFolder(null, ResourceMarker.sqtFolder)));
        IFile file = null;
        file = name == null ? this.createRandomFile(folder) : ResourceMarker.createFile(folder, String.valueOf(name) + "." + this.fExtention);
        if (this.fExtention.equals("sql")) {
            Application.openNewSQLEditor(file, this.connectionProperties.getDisplayString());
        } else if (this.fExtention.equals("yaml")) {
            Application.openNewYamlEditor(file);
        } else if (this.fExtention.equals("lst")) {
            SchemaDiagramEditor lstEditor = Application.openNewSchemaDiagramEditor(file);
            lstEditor.setConnectionCombo(SQLServerThread.getSQLServer().getConnectionSettingBean().getDisplayStrings(), this.connectionProperties.getDisplayString());
        }
    }

    public void run() {
        String name = null;
        if (!this.isScrap) {
            name = this.openNameDialog();
        }
        if (this.connectionProperties == null) {
            ConnectionSettingDialog dialog = null;
            List cons = null;
            cons = SQLServerThread.getSQLServer().getConnectionSettingBean().getConnectedConnectionSet();
            if (cons.size() == 0) {
                Application.openDialog("Information", Messages.getString("NewEditorDropDownAction.ActiveConnectionIsNothing"), 2);
                this.setEnabled(true);
                return;
            }
            if (cons.size() == 1) {
                this.connectionProperties = (ConnectionProperties)cons.iterator().next();
            } else {
                dialog = new ConnectionSettingDialog(Display.getCurrent().getActiveShell(), cons, null, 0);
                if (dialog.open() == 0) {
                    this.connectionProperties = dialog.getSelectedConnectionProperties();
                } else {
                    this.setEnabled(true);
                    return;
                }
            }
        }
        this.doOpenEditor(name);
    }

    public void setConnectionProperties(ConnectionProperties latestSelectedConnectionProperties) {
        this.connectionProperties = latestSelectedConnectionProperties;
        if (this.connectionProperties != null) {
            this.setEnabled(this.connectionProperties.isConnected());
        }
    }
}

