/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.wolfdbmanager;

import hiro.yoshioka.gef.editor.SchemaDiagramEditor;
import hiro.yoshioka.preferences.PreferenceConstants;
import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.ConnectionSettingBean;
import hiro.yoshioka.sql.ui.editor.SQLEditor;
import hiro.yoshioka.ui.util.GeneralPopUpDialog;
import hiro.yoshioka.ui.view.ChartResultSetView;
import hiro.yoshioka.ui.view.CountReportView;
import hiro.yoshioka.ui.view.DiffResultSetView;
import hiro.yoshioka.ui.view.ErrorView;
import hiro.yoshioka.ui.view.MultiResultSetView;
import hiro.yoshioka.ui.view.ResultSetView;
import hiro.yoshioka.ui.view.SingleResultSetView;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.util.logging.LogUtil;
import hiro.yoshioka.wolfdbmanager.Activator;
import hiro.yoshioka.wolfdbmanager.ApplicationWorkbenchAdvisor;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import hiro.yoshioka.yaml.editors.YamlEditor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.part.ViewPart;

public class Application
implements IApplication {
    private static final String SQLEDITOR_ID = "SQLEditorID";
    private static final String SQL = "sql";
    private static final String DOT_SQL = ".sql";
    public static final String SCRACH = "s__";
    protected static Log fLogger = LogFactory.getLog(Application.class.getClass());
    static Display display;
    static Shell my_shell;
    private static Tray tray;
    private static TrayItem tray_item;

    public Object start(IApplicationContext context) {
        display = PlatformUI.createDisplay();
        try {
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    public void stop() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }

    public static void setEnableAction(ViewPart part, String actionID, boolean b) {
        IContributionItem item = part.getViewSite().getActionBars().getToolBarManager().find(actionID);
        System.out.println("item = " + item + "/" + (item instanceof ActionContributionItem));
        if (item instanceof ActionContributionItem) {
            ((ActionContributionItem)item).getAction().setEnabled(b);
        }
    }

    public static void addAction(ViewPart part, String actionID, boolean b) {
        IToolBarManager tb = part.getViewSite().getActionBars().getToolBarManager();
        tb.find(actionID);
    }

    public static IWorkbench getWorkbench() {
        return Activator.getDefault().getWorkbench();
    }

    public static void restart() {
        IWorkbench w = Application.getWorkbench();
        if (w != null) {
            w.restart();
        }
    }

    public static IWorkbenchPage getWorkbenchPage() {
        IWorkbench w = Application.getWorkbench();
        if (w != null) {
            IWorkbenchWindow win = w.getActiveWorkbenchWindow();
            if (win != null) {
                return win.getActivePage();
            }
            IWorkbenchWindow[] wins = w.getWorkbenchWindows();
            if (wins.length > 1) {
                System.out.println("+[Window]---");
                int i = 0;
                while (i < wins.length) {
                    System.out.println("+-" + wins[i]);
                    ++i;
                }
            }
        }
        return null;
    }

    public static IWorkbenchPage[] getActiveAllWorkbenchPage() {
        IWorkbenchWindow win;
        IWorkbench w = Application.getWorkbench();
        if (w != null && (win = w.getActiveWorkbenchWindow()) != null) {
            return win.getPages();
        }
        return null;
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page = Application.getWorkbenchPage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    public static IEditorPart[] getEditors(String ext) {
        IWorkbenchPage page = Application.getWorkbenchPage();
        if (page != null) {
            ArrayList<IEditorPart> retList = new ArrayList<IEditorPart>();
            IEditorReference[] refs = page.getEditorReferences();
            int i = 0;
            while (i < refs.length) {
                if (refs[i].getTitle().endsWith(ext)) {
                    retList.add(refs[i].getEditor(false));
                }
                ++i;
            }
            return retList.toArray(new IEditorPart[retList.size()]);
        }
        return null;
    }

    public static void closeAllEditors() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
    }

    public static IEditorPart openNewEditor(IFile f) {
        IWorkbenchPage page = Application.getWorkbenchPage();
        if (page != null) {
            try {
                return IDE.openEditor((IWorkbenchPage)page, (IFile)f);
            }
            catch (Exception e) {
                fLogger.warn((Object)e);
            }
        }
        return null;
    }

    private static String getEditorId(IFileStore file) {
        IWorkbench w = Application.getWorkbench();
        IEditorRegistry editorRegistry = w.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName(), Application.getContentType(file));
        if (descriptor == null && editorRegistry.isSystemInPlaceEditorAvailable(file.getName())) {
            descriptor = editorRegistry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (descriptor == null && editorRegistry.isSystemExternalEditorAvailable(file.getName())) {
            descriptor = editorRegistry.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    private static IContentType getContentType(IFileStore fileStore) {
        if (fileStore == null) {
            return null;
        }
        InputStream stream = null;
        try {
            stream = fileStore.openInputStream(0, null);
            IContentType iContentType = Platform.getContentTypeManager().findContentTypeFor(stream, fileStore.getName());
            return iContentType;
        }
        catch (IOException x) {
            EditorsPlugin.log((Throwable)x);
            return null;
        }
        catch (CoreException x) {
            if (!(x.getStatus().getException() instanceof FileNotFoundException)) {
                EditorsPlugin.log((Throwable)x);
            }
            return null;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException x) {
                EditorsPlugin.log((Throwable)x);
            }
        }
    }

    public static YamlEditor openNewYamlEditor(IFile f) {
        if (f == null) {
            IFolder folder = ResourceMarker.getFolder(null, ResourceMarker.yamlFolder);
            f = ResourceMarker.createRandomFile(folder, ResourceMarker.yamlFolder);
        }
        System.out.println("fhowfhowefwoehoiw");
        IEditorPart ie = Application.openNewEditor(f);
        System.out.println("fhowfhowefwoehoiw::" + ie);
        if (ie instanceof YamlEditor) {
            YamlEditor yamlEditor = (YamlEditor)ie;
            yamlEditor.setPartName(f.getName());
            return yamlEditor;
        }
        return null;
    }

    public static SQLEditor openNewSQLEditor(IFile f, String defaultDisplayName) {
        IEditorPart ie;
        if (f == null) {
            IFolder folder = ResourceMarker.getFolder(null, ResourceMarker.sqlFolder);
            f = ResourceMarker.createRandomFile(folder, ResourceMarker.sqlFolder);
        }
        if ((ie = Application.openNewEditor(f)) instanceof SQLEditor) {
            SQLEditor sqlEditor = (SQLEditor)ie;
            sqlEditor.setConnectionCombo(SQLServerThread.getSQLServer().getConnectionSettingBean().getDisplayStrings(), defaultDisplayName);
            return sqlEditor;
        }
        return null;
    }

    public static SchemaDiagramEditor openNewSchemaDiagramEditor(IFile f) {
        return Application.openNewSchemaDiagramEditor(f, null);
    }

    public static SchemaDiagramEditor openNewSchemaDiagramEditor(IFile f, ConnectionProperties p) {
        IEditorPart ie;
        if (f == null) {
            IFolder folder = ResourceMarker.getFolder(null, ResourceMarker.lstFolder);
            f = ResourceMarker.createRandomFile(folder, ResourceMarker.lstFolder);
        }
        if ((ie = Application.openNewEditor(f)) instanceof SchemaDiagramEditor) {
            SchemaDiagramEditor lstEditor = (SchemaDiagramEditor)ie;
            if (p != null) {
                lstEditor.setConnectionCombo(SQLServerThread.getSQLServer().getConnectionSettingBean().getDisplayStrings(), p.getDisplayString());
            }
            return lstEditor;
        }
        return null;
    }

    public static void saveEditor() {
        IEditorPart editor = Application.getActiveEditor();
        if (editor == null) {
            return;
        }
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    public static SQLEditor getActiveSQLEditor() {
        IEditorPart editor = Application.getActiveEditor();
        if (editor instanceof SQLEditor) {
            return (SQLEditor)editor;
        }
        return null;
    }

    public static ConnectionProperties getActiveSQLEditorConnectionProperties() {
        SQLEditor editor = Application.getActiveSQLEditor();
        if (editor != null) {
            ConnectionSettingBean bean = SQLServerThread.getSQLServer().getConnectionSettingBean();
            return bean.getConnectionPropertiesByDisplay(editor.getConnectionDisplayString());
        }
        return null;
    }

    public static SchemaDiagramEditor getActiveSchemaDiagramEditor() {
        IEditorPart editor = Application.getActiveEditor();
        if (editor instanceof SchemaDiagramEditor) {
            return (SchemaDiagramEditor)editor;
        }
        return null;
    }

    public static DatabaseType getActiveSchemaDiagramDatabaseType() {
        SchemaDiagramEditor editor = Application.getActiveSchemaDiagramEditor();
        if (editor == null) {
            return DatabaseType.UNKNOWN;
        }
        ConnectionProperties prop = editor.getConnectionPropeteis();
        if (prop == null) {
            String disp = editor.getConnectionDisplayString();
            if (StringUtil.isEmpty((Object)disp)) {
                return DatabaseType.UNKNOWN;
            }
            prop = SQLServerThread.getSQLServer().getConnectionSettingBean().getConnectionPropertiesByDisplay(disp);
        }
        if (prop == null) {
            return DatabaseType.UNKNOWN;
        }
        return prop.getDatabaseType();
    }

    public static boolean opendSQLEditors() {
        IWorkbenchPage page = Application.getWorkbenchPage();
        IEditorPart[] parts = null;
        boolean one = false;
        if (page != null && (parts = page.getEditors()) != null) {
            int i = 0;
            while (i < parts.length) {
                if (parts[i] instanceof SQLEditor) {
                    if (one) {
                        return true;
                    }
                    one = true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String[] getSQLEditorInputs() {
        IWorkbenchPage page = Application.getWorkbenchPage();
        IEditorPart[] parts = null;
        if (page != null && (parts = page.getEditors()) != null) {
            ArrayList<String> retList = new ArrayList<String>();
            int i = 0;
            while (i < parts.length) {
                SQLEditor editor;
                if (parts[i] instanceof SQLEditor && (editor = (SQLEditor)parts[i]) != null) {
                    IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                    String statement = doc.get().trim();
                    if (statement.endsWith(";")) {
                        statement = statement.substring(0, statement.length() - 1);
                    }
                    if (statement.length() > 0) {
                        retList.add(statement);
                    }
                }
                ++i;
            }
            return retList.toArray(new String[retList.size()]);
        }
        return new String[0];
    }

    public static String getActiveSQLEditorInput() {
        SQLEditor editor = Application.getActiveSQLEditor();
        if (editor != null) {
            return editor.getText();
        }
        return null;
    }

    public static IViewPart findActiveView(String viewId) {
        IWorkbenchPage page = Application.getWorkbenchPage();
        if (page != null) {
            return page.findView(viewId);
        }
        return null;
    }

    public static void resetLogColor() {
        String[] levels = PreferenceConstants.VIEW_CONSOLE_LEVEL_FG_ARRAY;
        int i = 0;
        while (i < levels.length) {
            Color fg = PreferenceUtil.getColor(levels[i], display);
            Color bg = PreferenceUtil.getColor(PreferenceConstants.VIEW_CONSOLE_LEVEL_BG_ARRAY[i], display);
            LogUtil.setColorLevel((String)LogUtil.A_LEVELS[i], (Color)fg, (Color)bg);
            ++i;
        }
    }

    public static void showErrorView() {
        IWorkbenchPage page = Application.getWorkbenchPage();
        if (page != null) {
            try {
                page.showView(ErrorView.ID);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    public static CountReportView showCountRecordView() {
        IWorkbenchPage page = Application.getWorkbenchPage();
        if (page != null) {
            try {
                return (CountReportView)page.showView("CountReportViewID");
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static IViewPart findActiveView(String viewId, String secondaryId) {
        IWorkbenchPage page = Application.getWorkbenchPage();
        if (page != null) {
            return page.findViewReference(viewId, secondaryId).getView(true);
        }
        return null;
    }

    public static IViewReference[] findActiveViews(String viewId) {
        IWorkbenchPage page = Application.getWorkbenchPage();
        IViewReference[] ref = page.getViewReferences();
        ArrayList<IViewReference> list = new ArrayList<IViewReference>();
        int i = 0;
        while (i < ref.length) {
            if (viewId.equals(ref[i].getId())) {
                list.add(ref[i]);
            }
            ++i;
        }
        return list.toArray(new IViewReference[list.size()]);
    }

    public static DiffResultSetView showAndCreateDiffRstView(String secondId) {
        IWorkbenchPage page = Application.getWorkbenchPage();
        if (page != null) {
            try {
                return (DiffResultSetView)page.showView("DiffResultSetViewID", secondId, 1);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void closeView(String title) {
        WorkbenchPage page = (WorkbenchPage)Application.getWorkbenchPage();
        if (page != null) {
            try {
                IViewReference[] refs = page.getViewReferences();
                int i = 0;
                while (i < refs.length) {
                    if (refs[i].getPartName().equals(title)) {
                        page.hideView(refs[i]);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeAllViews() {
        WorkbenchPage page = (WorkbenchPage)Application.getWorkbenchPage();
        if (page != null) {
            try {
                IViewReference[] refs = page.getViewReferences();
                int i = 0;
                while (i < refs.length) {
                    if (refs[i].getId().equals("ChartResultSetViewID") || refs[i].getId().equals("RhinoViewID") || refs[i].getId().equals("GuessNumberViewID") || refs[i].getId().equals("MultiResultSetViewID") || refs[i].getId().equals("ResultSetViewID") || refs[i].getId().equals("DiffResultSetViewID")) {
                        page.hideView(refs[i]);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static ChartResultSetView showAndCreateChartRstView(String secondId) {
        IWorkbenchPage page = Application.getWorkbenchPage();
        if (page != null) {
            try {
                return (ChartResultSetView)page.showView("ChartResultSetViewID", secondId, 1);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static IViewPart showView(String viewID, String secondId, boolean popup) {
        fLogger.trace((Object)("viewID[" + viewID + "/doPopup[" + popup + "]"));
        ViewPart part = null;
        IWorkbenchPage page = Application.getWorkbenchPage();
        IPreferenceStore store = null;
        int openViewMode = 0;
        if (page != null) {
            try {
                if (popup) {
                    store = WorkbenchPlugin.getDefault().getPreferenceStore();
                    openViewMode = store.getInt("OPEN_VIEW_MODE");
                    store.setValue("OPEN_VIEW_MODE", 2);
                }
                part = (ViewPart)page.showView(viewID, secondId, 1);
                if (popup) {
                    store.setValue("OPEN_VIEW_MODE", openViewMode);
                }
            }
            catch (PartInitException e) {
                fLogger.error((Object)"", (Throwable)e);
            }
        }
        return part;
    }

    public static SingleResultSetView showAndCreateSessionView() {
        IWorkbenchPage page = Application.getWorkbenchPage();
        if (page != null) {
            try {
                return (SingleResultSetView)page.showView("SessionViewID");
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static ResultSetView showAndCreateRstView(String secondId) {
        IWorkbenchPage page = Application.getWorkbenchPage();
        if (page != null) {
            try {
                return (ResultSetView)page.showView("ResultSetViewID", secondId, 1);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static MultiResultSetView showAndCreateMultiRstView(String secondId) {
        IWorkbenchPage page = Application.getWorkbenchPage();
        if (page != null) {
            try {
                return (MultiResultSetView)page.showView("MultiResultSetViewID", secondId, 1);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static int openPreferenceDialog(String pageId) {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)pageId, null, null);
        return dialog.open();
    }

    public static boolean activeOutline() {
        IViewPart page = Application.findActiveView("org.eclipse.ui.views.ContentOutline");
        return page != null;
    }

    public static void showProgressView() {
        IWorkbenchPage page = Application.getWorkbenchPage();
        if (page != null) {
            try {
                page.showView("org.eclipse.ui.views.ProgressView");
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    public static void dumpViews() {
        IWorkbenchPage page = Application.getWorkbenchPage();
        if (page != null) {
            IViewReference[] ref = page.getViewReferences();
            int i = 0;
            while (i < ref.length) {
                System.out.println(String.valueOf(ref[i].getId()) + "/" + ref[i].getSecondaryId() + "/" + ref[i].getTitle());
                ++i;
            }
        }
    }

    public static void timer_exec(int milliseconds, Runnable runnable) {
        display.timerExec(milliseconds, runnable);
    }

    public static boolean currentTreadIsDispaly() {
        return display.getThread() == Thread.currentThread();
    }

    public static void createBalloon(String title, String message) {
        Application.createBalloon(title, message, 2);
    }

    public static void createBalloon(String title, String message, int icon_type) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (tray == null) {
                    Application.tray = display.getSystemTray();
                }
                if (tray == null) {
                    System.err.println(" tray is null..");
                    return;
                }
                if (tray_item == null || tray_item.isDisposed()) {
                    tray_item = new TrayItem(tray, 0);
                    Image image = display.getSystemImage(2);
                    tray_item.setImage(image);
                }
                try {
                    ToolTip tip = new ToolTip(my_shell, 0x1000 | icon_type);
                    tip.setText(title);
                    tip.setMessage(message);
                    tip.setAutoHide(true);
                    tray_item.setToolTip(tip);
                    tip.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void exec(Runnable runnable) {
        if (!display.isDisposed()) {
            try {
                if (display.getThread() != Thread.currentThread()) {
                    display.asyncExec(runnable);
                    return;
                }
                runnable.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void openDialog(String title, String message, int style) {
        Application.openDialog(null, title, message, style);
    }

    public static void openDialog(Shell shell, String title, String message, int style) {
        Application.exec(new GeneralPopUpDialog(shell, title, message, style));
    }

    public static void openErrorDialog(Shell shell, String title, Throwable e) {
        Application.exec(new GeneralPopUpDialog(shell, title, e, 1));
    }

    public static void setStatus(String message) {
        if (display.getThread() != Thread.currentThread()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbench wb = PlatformUI.getWorkbench();
                    WorkbenchWindow w = (WorkbenchWindow)wb.getActiveWorkbenchWindow();
                    w.getStatusLineManager().setMessage(message);
                }
            });
        } else {
            IWorkbench wb = PlatformUI.getWorkbench();
            WorkbenchWindow w = (WorkbenchWindow)wb.getActiveWorkbenchWindow();
            w.getStatusLineManager().setMessage(message);
        }
    }

    public static void setDefaultShell(Shell shell) {
        my_shell = shell;
    }
}

