/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartExpressionProvider
extends ExpressionProvider {
    public static final String CHART_VARIABLES = Messages.getString("ChartExpressionProvider.Category.ChartVariables");
    private static final String DATA_POINTS = Messages.getString("ChartExpressionProvider.ChartVariables.DataPoints");
    private static final String LEGEND_ITEMS = Messages.getString("ChartExpressionProvider.ChartVariables.LegendItems");
    private static final String JAVASCRIPT = Messages.getString("ChartExpressionProvider.ChartVariables.JavaScript");
    private static final String JAVASCRIPT_EVENT = Messages.getString("ChartExpressionProvider.ChartVariables.Event");
    private static final String JAVASCRIPT_EVENT_PARAMETER = "evt";
    public static final int CATEGORY_BASE = 0;
    public static final int CATEGORY_WITH_DATA_POINTS = 1;
    public static final int CATEGORY_WITH_BIRT_VARIABLES = 2;
    public static final int CATEGORY_WITH_COLUMN_BINDINGS = 4;
    public static final int CATEGORY_WITH_REPORT_PARAMS = 8;
    public static final int CATEGORY_WITH_JAVASCRIPT = 16;
    public static final int CATEGORY_WITH_LEGEND_ITEMS = 32;
    private final int _categoryStyle;
    private final ChartWizardContext wizardContext;

    public ChartExpressionProvider() {
        this(null, null, 0);
    }

    public ChartExpressionProvider(DesignElementHandle handle, ChartWizardContext wizardContext, int categoryStyle) {
        super(handle, true);
        this.wizardContext = wizardContext;
        this._categoryStyle = categoryStyle;
        this.init();
    }

    private void init() {
        final ArrayList<String> filteredList = new ArrayList<String>(3);
        filteredList.add(CURRENT_CUBE);
        if ((this._categoryStyle & 2) != 2) {
            filteredList.add(BIRT_OBJECTS);
        }
        if ((this._categoryStyle & 4) != 4) {
            filteredList.add(COLUMN_BINDINGS);
        }
        if ((this._categoryStyle & 8) != 8) {
            filteredList.add(PARAMETERS);
        }
        if (!filteredList.isEmpty()) {
            this.addFilter(new ExpressionFilter(){

                public boolean select(Object parentElement, Object element) {
                    return !filteredList.contains(element);
                }
            });
        }
        this.addFilter(new ExpressionFilter(){

            public boolean select(Object parentElement, Object element) {
                if (!"Category".equals(parentElement)) {
                    return true;
                }
                if (element instanceof String) {
                    return !ChartExpressionProvider.this.isDataSetOrCubeCategory(element);
                }
                return true;
            }
        });
    }

    private boolean isDataSetOrCubeCategory(Object element) {
        return ExpressionProvider.DATASETS.equals(element) || ExpressionProvider.CURRENT_CUBE.equals(element);
    }

    protected List<Object> getCategoryList() {
        List list = super.getCategoryList();
        if (!((this._categoryStyle & 1) != 1 && (this._categoryStyle & 0x10) != 16 && (this._categoryStyle & 0x20) != 32 || list.contains(CHART_VARIABLES))) {
            list.add(CHART_VARIABLES);
        }
        return list;
    }

    protected List<Object> getChildrenList(Object parent) {
        List list = super.getChildrenList(parent);
        if (CHART_VARIABLES.equals(parent)) {
            if ((this._categoryStyle & 1) == 1) {
                list.add(DATA_POINTS);
            }
            if ((this._categoryStyle & 0x10) == 16) {
                list.add(JAVASCRIPT);
            }
            if ((this._categoryStyle & 0x20) == 32) {
                list.add(LEGEND_ITEMS);
            }
        } else if (DATA_POINTS.equals(parent)) {
            list.add("categoryData");
            list.add("valueData");
            list.add("valueSeriesName");
        } else if (LEGEND_ITEMS.equals(parent)) {
            list.add("legendItemText");
            list.add("legendItemValue");
        } else if (JAVASCRIPT.equals(parent)) {
            list.add(JAVASCRIPT_EVENT_PARAMETER);
        }
        return list;
    }

    public String getDisplayText(Object element) {
        if (element.equals("categoryData")) {
            return Messages.getString("ChartExpressionProvider.DataPoints.BaseValue");
        }
        if (element.equals("valueData")) {
            return Messages.getString("ChartExpressionProvider.DataPoints.OrthogonalValue");
        }
        if (element.equals("valueSeriesName")) {
            return Messages.getString("ChartExpressionProvider.DataPoints.SeriesValue");
        }
        if (element.equals(JAVASCRIPT_EVENT_PARAMETER)) {
            return JAVASCRIPT_EVENT;
        }
        return super.getDisplayText(element);
    }

    protected Iterator<ComputedColumnHandle> getColumnBindings(ReportItemHandle handle) {
        if (this.isInheritColumnsOnly()) {
            ArrayList<ComputedColumnHandle> bindings = new ArrayList<ComputedColumnHandle>();
            Iterator iterator = handle.columnBindingsIterator();
            while (iterator.hasNext()) {
                ComputedColumnHandle cch = (ComputedColumnHandle)iterator.next();
                if (cch.getAggregateFunction() != null) continue;
                bindings.add(cch);
            }
            return bindings.iterator();
        }
        return super.getColumnBindings(handle);
    }

    private boolean isInheritColumnsOnly() {
        ReportItemHandle itemHandle = (ReportItemHandle)this.elementHandle;
        if (this.wizardContext == null) {
            return ChartItemUtil.isChartInheritColumnsOnly((ReportItemHandle)itemHandle);
        }
        return itemHandle.getDataSet() == null && ChartReportItemUtil.isContainerInheritable((ReportItemHandle)itemHandle) && this.wizardContext != null && this.wizardContext.isInheritColumnsOnly();
    }

    protected void addEditBindingsItem(ArrayList<Object> childrenList, String itemText, Object parent) {
        ReportItemHandle itemHandle = (ReportItemHandle)this.elementHandle;
        if (!ChartItemUtil.isChildOfMultiViewsHandle((DesignElementHandle)itemHandle)) {
            childrenList.add(new Object[]{itemText, parent});
        }
    }
}

