/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.el.ELTargetRuntimeException;
import woolpack.el.GettingEL;
import woolpack.el.GettingELAdapter;

public class DomConstants {
    public static final GettingEL CONTAINER_EL = new GettingELAdapter(){

        public Object getValue(Object root, Class clazz) throws ELTargetRuntimeException {
            return ((DomContext)root).getContainer();
        }
    };
    public static final GettingEL SESSION_EL = new GettingELAdapter(){

        public Object getValue(Object root, Class clazz) throws ELTargetRuntimeException {
            return ((DomContext)root).getSession();
        }
    };
    public static final GettingEL LOCAL_EL = new GettingELAdapter(){

        public Object getValue(Object root, Class clazz) throws ELTargetRuntimeException {
            return ((DomContext)root).getLocal();
        }
    };
    public static final GettingEL CONFIG_EL = new GettingELAdapter(){

        public Object getValue(Object root, Class clazz) throws ELTargetRuntimeException {
            return ((DomContext)root).getConfig();
        }
    };
    public static final GettingEL INPUT_EL = new GettingELAdapter(){

        public Object getValue(Object root, Class clazz) throws ELTargetRuntimeException {
            return ((DomContext)root).getInput();
        }
    };
    public static final GettingEL REQUEST_EL = new GettingELAdapter(){

        public Object getValue(Object root, Class clazz) throws ELTargetRuntimeException {
            return ((DomContext)root).getRequest();
        }
    };
    public static final GettingEL APPLICATION_EL = new GettingELAdapter(){

        public Object getValue(Object root, Class clazz) throws ELTargetRuntimeException {
            return ((DomContext)root).getApplication();
        }
    };
    public static final DomExpression NULL = new DomExpression(){

        public void interpret(DomContext context) {
        }
    };
    public static final DomExpression REMOVE_THIS = new DomExpression(){

        public void interpret(DomContext context) {
            DomConstants.removeThis(context.getNode());
        }
    };
    public static final DomExpression REMOVE_CHILDREN = new DomExpression(){

        public void interpret(DomContext context) {
            DomConstants.removeChildren(context.getNode());
        }
    };
    public static final DomExpression RETAIN_CHILDREN = new DomExpression(){

        public void interpret(DomContext context) {
            DomConstants.retainChildren(context.getNode());
        }
    };
    public static final DomExpression CLEAR_SESSION = new DomExpression(){

        public void interpret(DomContext context) {
            context.getSession().clear();
        }
    };

    private DomConstants() {
    }

    public static void removeThis(Node node) {
        node.getParentNode().removeChild(node);
    }

    public static void removeChildren(Node node) {
        Node child = null;
        while ((child = node.getFirstChild()) != null) {
            node.removeChild(child);
        }
    }

    public static void retainChildren(Node node) {
        Node parent = node.getParentNode();
        Node child = null;
        while ((child = node.getFirstChild()) != null) {
            parent.insertBefore(child, node);
        }
        parent.removeChild(node);
    }

    public static void appendText(Node node, String text) {
        node.appendChild(DomConstants.getDocumentNode(node).createTextNode(text));
    }

    public static Document getDocumentNode(Node node) {
        return node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
    }

    public static void write(Node node, Writer writer) {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer transformer = factory.newTransformer();
            DOMSource source = new DOMSource(node);
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }
}

