/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el;

import java.lang.reflect.Array;
import java.util.Collection;
import woolpack.el.TypeConverter;
import woolpack.utils.UtilsConstants;

public class CollectionTypeConverter
implements TypeConverter {
    private final TypeConverter converter;

    public CollectionTypeConverter(TypeConverter converter) {
        converter.getClass();
        this.converter = converter;
    }

    public Object convert(String propertyName, Object beforeValue, Class toType) {
        if (Object.class.equals((Object)toType)) {
            return beforeValue;
        }
        Collection collection = UtilsConstants.toCollection(beforeValue);
        if (toType.isArray()) {
            Object afterArray = Array.newInstance(toType.getComponentType(), collection.size());
            int i = 0;
            for (Object before : collection) {
                Object after = this.converter.convert(propertyName, before, toType.getComponentType());
                Array.set(afterArray, i, after);
                ++i;
            }
            return afterArray;
        }
        if (Collection.class.isAssignableFrom(toType)) {
            return collection;
        }
        Object value = collection.iterator().next();
        if (value != null) {
            return this.converter.convert(propertyName, value, toType);
        }
        return value;
    }
}

