/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import woolpack.el.TypeConverter;

class SimpleTypeConverter
implements TypeConverter {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
    private final DateFormat dateTimeFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    SimpleTypeConverter() {
    }

    private static boolean isByte(Class toType) {
        return Byte.class.isAssignableFrom(toType) || Byte.TYPE.isAssignableFrom(toType);
    }

    private static boolean isDouble(Class toType) {
        return Double.class.isAssignableFrom(toType) || Double.TYPE.isAssignableFrom(toType);
    }

    private static boolean isFloat(Class toType) {
        return Float.class.isAssignableFrom(toType) || Float.TYPE.isAssignableFrom(toType);
    }

    private static boolean isInteger(Class toType) {
        return Integer.class.isAssignableFrom(toType) || Integer.TYPE.isAssignableFrom(toType);
    }

    private static boolean isLong(Class toType) {
        return Long.class.isAssignableFrom(toType) || Long.TYPE.isAssignableFrom(toType);
    }

    private static boolean isShort(Class toType) {
        return Short.class.isAssignableFrom(toType) || Short.TYPE.isAssignableFrom(toType);
    }

    public Object convert(String propertyName, Object beforeValue, Class toType) {
        if (beforeValue == null) {
            return null;
        }
        if (String.class.isAssignableFrom(toType)) {
            return beforeValue.toString();
        }
        if (Boolean.class.isAssignableFrom(toType)) {
            return new Boolean("true".equals(beforeValue));
        }
        if (Character.class.isAssignableFrom(toType)) {
            return new Character(beforeValue.toString().charAt(0));
        }
        if (Number.class.isAssignableFrom(beforeValue.getClass())) {
            Number n = (Number)beforeValue;
            if (SimpleTypeConverter.isInteger(toType)) {
                return new Integer(n.intValue());
            }
            if (SimpleTypeConverter.isLong(toType)) {
                return new Long(n.longValue());
            }
            if (SimpleTypeConverter.isShort(toType)) {
                return new Short(n.shortValue());
            }
            if (SimpleTypeConverter.isByte(toType)) {
                return new Byte(n.byteValue());
            }
            if (SimpleTypeConverter.isDouble(toType)) {
                return new Double(n.doubleValue());
            }
            if (SimpleTypeConverter.isFloat(toType)) {
                return new Float(n.floatValue());
            }
        }
        if (String.class.isAssignableFrom(beforeValue.getClass())) {
            String s = (String)beforeValue;
            if (SimpleTypeConverter.isInteger(toType)) {
                return new Integer(s);
            }
            if (SimpleTypeConverter.isLong(toType)) {
                return new Long(s);
            }
            if (Date.class.isAssignableFrom(toType)) {
                try {
                    Date date = s.length() == 8 ? ((DateFormat)this.dateFormat.clone()).parse(s) : (s.length() == 14 ? ((DateFormat)this.dateTimeFormat.clone()).parse(s) : null);
                    if (date != null) {
                        if (java.sql.Date.class.isAssignableFrom(toType)) {
                            return new java.sql.Date(date.getTime());
                        }
                        return date;
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (SimpleTypeConverter.isShort(toType)) {
                return new Short(s);
            }
            if (SimpleTypeConverter.isByte(toType)) {
                return new Byte(s);
            }
            if (SimpleTypeConverter.isDouble(toType)) {
                return new Double(s);
            }
            if (SimpleTypeConverter.isFloat(toType)) {
                return new Float(s);
            }
        }
        return beforeValue;
    }
}

