/*
 * Decompiled with CFR 0.152.
 */
package woolpack.html;

import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.dom.NodeLoop;
import woolpack.utils.XPathWrapper;

public class HtmlConstants {
    static final XPathWrapper XPATH_OPTION = new XPathWrapper("//OPTION");
    public static final DomExpression REMOVE_THIS_AND_TEXTS = new DomExpression(){

        public void interpret(DomContext context) {
            HtmlConstants.removeThisAndText(context.getNode());
        }
    };
    public static final DomExpression NORMALIZE = new NodeLoop(){

        public void interpret(DomContext context) {
            super.interpret(context);
            if (context.getNode().getNodeType() == 1) {
                Element e = (Element)context.getNode();
                Element newE = DomConstants.getDocumentNode(e).createElement(e.getNodeName().toUpperCase());
                NamedNodeMap attrs = e.getAttributes();
                int i = 0;
                while (i < attrs.getLength()) {
                    Attr attr = (Attr)attrs.item(i);
                    newE.setAttribute(attr.getName().toLowerCase(), attr.getNodeValue());
                    ++i;
                }
                Node child = null;
                while ((child = e.getFirstChild()) != null) {
                    newE.appendChild(child);
                }
                e.getParentNode().replaceChild(newE, e);
            }
        }
    };

    private HtmlConstants() {
    }

    public static void removeThisAndText(Node node) {
        Node nextNode = node.getNextSibling();
        while (nextNode != null && nextNode.getNodeType() == 3) {
            DomConstants.removeThis(nextNode);
            nextNode = node.getNextSibling();
        }
        DomConstants.removeThis(node);
    }
}

