/*
 * Decompiled with CFR 0.152.
 */
package woolpack.validator;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import woolpack.validator.ValidatorConstants;
import woolpack.validator.ValidatorContext;
import woolpack.validator.ValidatorExpression;
import woolpack.validator.ValidatorExpressionAdapter;
import woolpack.validator.ValidatorIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialValidator
extends ValidatorExpressionAdapter {
    private final ValidatorIterable validatorIterable;
    private final Iterable<? extends ValidatorExpression> iterable;

    public SerialValidator(ValidatorIterable validatorIterable, Iterable<? extends ValidatorExpression> iterable) {
        validatorIterable.getClass();
        iterable.getClass();
        this.validatorIterable = validatorIterable;
        this.iterable = iterable;
    }

    public SerialValidator(Iterable<? extends ValidatorExpression> iterable) {
        this(ValidatorConstants.ANDAND, iterable);
    }

    public SerialValidator(ValidatorIterable validatorIterable, ValidatorExpression ... expressions) {
        this(validatorIterable, (Iterable<? extends ValidatorExpression>)Arrays.asList(expressions));
    }

    public SerialValidator(ValidatorExpression ... expressions) {
        this(ValidatorConstants.ANDAND, (Iterable<? extends ValidatorExpression>)Arrays.asList(expressions));
    }

    @Override
    public boolean interpret(ValidatorContext context) {
        return this.validatorIterable.interpret(context, this.iterable);
    }

    @Override
    public void appendArgumentTo(Appendable sb) throws IOException {
        this.validatorIterable.appendTo(sb);
        sb.append(",[");
        boolean flag = false;
        for (ValidatorExpression validatorExpression : this.iterable) {
            if (flag) {
                sb.append(',');
            }
            flag = true;
            validatorExpression.appendTo(sb);
        }
        sb.append(']');
    }

    @Override
    public void addMessageTo(Collection<String> messageCollection) {
        for (ValidatorExpression validatorExpression : this.iterable) {
            validatorExpression.addMessageTo(messageCollection);
        }
    }
}

