/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.locale;

import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

import woolpack.config.ConfigContext;
import woolpack.config.ConfigExpression;
import woolpack.config.PutResourceBundle;

/**
 * スレッドの{@link Locale}により{@link ResourceBundle}を読み込み{@link ConfigContext#setMap(Map)}に追加する{@link ConfigExpression}。
 * @author nakamura
 *
 */
public class LocalePutResourceBundle extends PutResourceBundle {
	private final ThreadLocal<Locale> threadLocal;

	/**
	 * コンストラクタ。
	 * @param path {@link ResourceBundle}の識別子。
	 * @param threadLocal 現在のスレッドの{@link Locale}を保持する{@link ThreadLocal}。
	 * @throws NullPointerException 引数のいずれかが null の場合。
	 * @throws StringIndexOutOfBoundsException path が空の場合。
	 */
	public LocalePutResourceBundle(final String path, final ThreadLocal<Locale> threadLocal) {
		super(path);
		threadLocal.getClass();
		this.threadLocal = threadLocal;
	}

	@Override public ResourceBundle getResourceBundle(final String path){
		final Locale l = threadLocal.get();
		return (l!=null)?ResourceBundle.getBundle(path, l):super.getResourceBundle(path);
	}
}
