/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.io.IOException;

/**
 * 一時キーを{@link ValidatorContext#setTmpKey(String)}に設定して委譲する{@link ValidatorExpression}。
 * @author nakamura
 *
 */
public class TmpKeyValidator extends DelegationValidator {
	private final String tmpKey;

	/**
	 * コンストラクタ。
	 * @param tmpKey 一時キー。
	 * @param expression 委譲先。
	 * @throws StringIndexOutOfBoundsException tmpKey が空の場合。
	 * @throws NullPointerException 引数のいずれかが null の場合。
	 */
	public TmpKeyValidator(final String tmpKey, final ValidatorExpression expression){
		super(expression);
		tmpKey.charAt(0);
		this.tmpKey = tmpKey;
	}
	
	@Override public boolean interpret(final ValidatorContext context){
		final ValidatorContext newContext = context.copy();
		newContext.setTmpKey(tmpKey);
		return super.interpret(newContext);
	}

	@Override public void appendArgumentTo(final Appendable sb) throws IOException{
		ValidatorConstants.appendTo(sb, tmpKey);
		sb.append(',');
		super.appendArgumentTo(sb);
	}
}
