/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import junit.framework.TestCase;

public class SerialTest extends TestCase {

	public void testConstructor(){
		try{
			new Serial((Iterable<DomExpression>)null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal4(){
		final Count[] counters = {new Count(DomConstants.NULL), new Count(DomConstants.NULL), new Count(DomConstants.NULL)};
		final DomExpression expression = new Serial((DomExpression[])counters);
		for(int i=0; i<counters.length; i++){
			assertEquals(0, counters[i].getCount());
		}
		{
			final DomContext context = new DomContext();
			expression.interpret(context);
			for(int i=0; i<counters.length; i++){
				assertEquals(1, counters[i].getCount());
				assertTrue(context == counters[i].getContextList().getLast());
			}
		}
		{
			final DomContext context = new DomContext();
			expression.interpret(context);
			for(int i=0; i<counters.length; i++){
				assertEquals(2, counters[i].getCount());
				assertTrue(context == counters[i].getContextList().getLast());
			}
		}
	}
}
