/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import junit.framework.TestCase;

public class SleepTest extends TestCase {
	long interpterDate;
	final DomExpression recodeDate = new DomExpression(){
		public void interpret(final DomContext context) {
			interpterDate = System.currentTimeMillis();
		}
	};

	public void testConstructor(){
		try{
			new Sleep(0, 0, null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal(){
		final Count counter0 = new Count(recodeDate);
		final DomExpression expression = new Sleep(100, 300, counter0);
		final DomContext context = new DomContext();
		
		final long before = System.currentTimeMillis();
		expression.interpret(context);
		final long after = System.currentTimeMillis();
		assertTrue(Math.abs(Math.abs(before - interpterDate) - 100) <= 10);
		assertTrue(Math.abs(Math.abs(after - interpterDate) - 300) <= 10);
	}
	
	public void testZero(){
		final Count counter0 = new Count(recodeDate);
		final DomExpression expression = new Sleep(0, 0, counter0);
		final DomContext context = new DomContext();
		
		final long before = System.currentTimeMillis();
		expression.interpret(context);
		final long after = System.currentTimeMillis();
		assertTrue(Math.abs(Math.abs(before - interpterDate) - 0) <= 10);
		assertTrue(Math.abs(Math.abs(after - interpterDate) - 0) <= 10);
	}
}
