/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import woolpack.el.ELTargetRuntimeException;
import woolpack.el.GettingELAdapter;

class SimpleTypeConvertEL
extends GettingELAdapter {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
    private final DateFormat dateTimeFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    SimpleTypeConvertEL() {
    }

    private static boolean isToByte(Class toType) {
        return Byte.class.isAssignableFrom(toType) || Byte.TYPE.isAssignableFrom(toType);
    }

    private static boolean isToDouble(Class toType) {
        return Double.class.isAssignableFrom(toType) || Double.TYPE.isAssignableFrom(toType);
    }

    private static boolean isToFloat(Class toType) {
        return Float.class.isAssignableFrom(toType) || Float.TYPE.isAssignableFrom(toType);
    }

    private static boolean isToInteger(Class toType) {
        return Integer.class.isAssignableFrom(toType) || Integer.TYPE.isAssignableFrom(toType);
    }

    private static boolean isToLong(Class toType) {
        return Long.class.isAssignableFrom(toType) || Long.TYPE.isAssignableFrom(toType);
    }

    private static boolean isToShort(Class toType) {
        return Short.class.isAssignableFrom(toType) || Short.TYPE.isAssignableFrom(toType);
    }

    public Object getValue(Object beforeValue, Class toType) throws ELTargetRuntimeException {
        if (beforeValue == null) {
            return null;
        }
        if (String.class.isAssignableFrom(toType)) {
            return beforeValue.toString();
        }
        if (Boolean.class.isAssignableFrom(toType)) {
            return new Boolean("true".equals(beforeValue));
        }
        if (Character.class.isAssignableFrom(toType)) {
            return new Character(beforeValue.toString().charAt(0));
        }
        if (Number.class.isAssignableFrom(beforeValue.getClass())) {
            Number n = (Number)beforeValue;
            if (SimpleTypeConvertEL.isToInteger(toType)) {
                return new Integer(n.intValue());
            }
            if (SimpleTypeConvertEL.isToLong(toType)) {
                return new Long(n.longValue());
            }
            if (SimpleTypeConvertEL.isToShort(toType)) {
                return new Short(n.shortValue());
            }
            if (SimpleTypeConvertEL.isToByte(toType)) {
                return new Byte(n.byteValue());
            }
            if (SimpleTypeConvertEL.isToDouble(toType)) {
                return new Double(n.doubleValue());
            }
            if (SimpleTypeConvertEL.isToFloat(toType)) {
                return new Float(n.floatValue());
            }
        }
        if (String.class.isAssignableFrom(beforeValue.getClass())) {
            String s = (String)beforeValue;
            if (SimpleTypeConvertEL.isToInteger(toType)) {
                return new Integer(s);
            }
            if (SimpleTypeConvertEL.isToLong(toType)) {
                return new Long(s);
            }
            if (Date.class.isAssignableFrom(toType)) {
                try {
                    Date date = s.length() == 8 ? ((DateFormat)this.dateFormat.clone()).parse(s) : (s.length() == 14 ? ((DateFormat)this.dateTimeFormat.clone()).parse(s) : null);
                    if (date != null) {
                        if (java.sql.Date.class.isAssignableFrom(toType)) {
                            return new java.sql.Date(date.getTime());
                        }
                        return date;
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (SimpleTypeConvertEL.isToShort(toType)) {
                return new Short(s);
            }
            if (SimpleTypeConvertEL.isToByte(toType)) {
                return new Byte(s);
            }
            if (SimpleTypeConvertEL.isToDouble(toType)) {
                return new Double(s);
            }
            if (SimpleTypeConvertEL.isToFloat(toType)) {
                return new Float(s);
            }
        }
        return beforeValue;
    }
}

