/*
 * Decompiled with CFR 0.152.
 */
package woolpack.validator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import woolpack.bool.BooleanState;
import woolpack.fn.Fn;
import woolpack.validator.AddressedMessage;
import woolpack.validator.ConvertValidator;
import woolpack.validator.LocalIndexValidator;
import woolpack.validator.LocalKeyValidator;
import woolpack.validator.MapGetter;
import woolpack.validator.MessageValidator;
import woolpack.validator.NameBranch;
import woolpack.validator.NameBranchIfExists;
import woolpack.validator.NameBranchIfNotEmpty;
import woolpack.validator.ValidatorContext;
import woolpack.validator.ValueGetter;
import woolpack.validator.ValueLoopValidator;
import woolpack.validator.ValuesGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidatorUtils {
    public static final Fn<Iterable<AddressedMessage>, List<String>, RuntimeException> TO_MESSAGE = new Fn<Iterable<AddressedMessage>, List<String>, RuntimeException>(){

        @Override
        public List<String> exec(Iterable<AddressedMessage> c) throws RuntimeException {
            ArrayList<String> list = new ArrayList<String>();
            for (AddressedMessage message : c) {
                list.add(message.getMessage());
            }
            return list;
        }
    };
    public static final Fn<ValidatorContext, Object, RuntimeException> VALUE = new ValueGetter<RuntimeException>();
    public static final Fn<ValidatorContext, Map<String, List<Object>>, RuntimeException> MAP = new MapGetter<RuntimeException>();
    public static final Fn<ValidatorContext, List<Object>, RuntimeException> VALUES = new ValuesGetter<RuntimeException>();

    private ValidatorUtils() {
    }

    public static final Fn<Iterable<AddressedMessage>, List<String>, RuntimeException> toOrderedMessage(final Iterable<String> iterable) {
        return new Fn<Iterable<AddressedMessage>, List<String>, RuntimeException>(){

            @Override
            public List<String> exec(Iterable<AddressedMessage> c) throws RuntimeException {
                ArrayList<String> list = new ArrayList<String>();
                for (String param : iterable) {
                    Iterator<AddressedMessage> it = c.iterator();
                    while (it.hasNext()) {
                        AddressedMessage message = it.next();
                        if (!param.equals(message.getKey())) continue;
                        list.add(message.getMessage());
                        it.remove();
                    }
                }
                for (AddressedMessage message : c) {
                    list.add(message.getMessage());
                }
                return list;
            }
        };
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> branchByNameIfExists(Fn<Object, ? extends BooleanState, ? extends RuntimeException> operator, Map<String, ? extends Fn<? super ValidatorContext, Boolean, ? extends E>> map) {
        return new NameBranchIfExists(operator, map);
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> branchByNameIfNotEmpty(Fn<Object, ? extends BooleanState, ? extends RuntimeException> operator, Map<String, ? extends Fn<? super ValidatorContext, Boolean, ? extends E>> map) {
        return new NameBranchIfNotEmpty(operator, map);
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> branchByName(Fn<Object, ? extends BooleanState, ? extends RuntimeException> operator, Map<String, ? extends Fn<? super ValidatorContext, Boolean, ? extends E>> map) {
        return new NameBranch(operator, map);
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> convertValue(Fn<Object, ?, ? extends E> fn) {
        return new ConvertValidator<E>(fn);
    }

    public static Fn<ValidatorContext, Boolean, RuntimeException> message(String message) {
        return new MessageValidator<RuntimeException>(message);
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> localIndex(int tmpIndex, Fn<? super ValidatorContext, Boolean, ? extends E> fn) {
        return new LocalIndexValidator<E>(tmpIndex, fn);
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> localKey(String tmpKey, Fn<? super ValidatorContext, Boolean, ? extends E> fn) {
        return new LocalKeyValidator<E>(tmpKey, fn);
    }

    public static <E extends Exception> Fn<ValidatorContext, Boolean, E> loopValue(Fn<Object, ? extends BooleanState, ? extends RuntimeException> operator, Fn<? super ValidatorContext, Boolean, ? extends E> fn) {
        return new ValueLoopValidator<E>(operator, fn);
    }
}

