/*
 * Decompiled with CFR 0.152.
 */
package woolpack.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import woolpack.container.ContainerContext;
import woolpack.container.ContainerUtils;
import woolpack.el.AbstractGettingEL;
import woolpack.el.GettingEL;
import woolpack.factory.FactoryUtils;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.utils.Utils;
import woolpack.web.ContainerContextSetter;
import woolpack.web.TransactionTokenFn;
import woolpack.web.WebContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebUtils {
    public static final GettingEL INPUT_EL = new AbstractGettingEL(){

        public Object getValue(Object root, Class clazz) {
            return ((WebContext)root).getInput();
        }
    };
    public static final GettingEL REQUEST_EL = new AbstractGettingEL(){

        public Object getValue(Object root, Class clazz) {
            return ((WebContext)root).getRequest();
        }
    };
    public static final GettingEL SESSION_EL = new AbstractGettingEL(){

        public Object getValue(Object root, Class clazz) {
            return ((WebContext)root).getSession();
        }
    };
    public static final GettingEL APPLICATION_EL = new AbstractGettingEL(){

        public Object getValue(Object root, Class clazz) {
            return ((WebContext)root).getApplication();
        }
    };
    public static final GettingEL CONTAINER_EL = new AbstractGettingEL(){

        public Object getValue(Object root, Class clazz) {
            return ((WebContext)root).getContainer();
        }
    };
    public static final Fn<WebContext, Void, RuntimeException> CLEAR_SESSION = new Fn<WebContext, Void, RuntimeException>(){

        @Override
        public Void exec(WebContext context) {
            context.getSession().clear();
            return null;
        }
    };

    private static <E extends Exception> Fn<ContainerContext<WebContext>, String, Exception> getKey() {
        return new Fn<ContainerContext<WebContext>, String, Exception>(){

            @Override
            public String exec(ContainerContext<WebContext> c) {
                return "woolpack.web.WebUtils." + c.getKey();
            }
        };
    }

    private WebUtils() {
    }

    public static Map<String, List<Object>> convert(Map map) {
        HashMap<String, List<Object>> map1 = new HashMap<String, List<Object>>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = iterator.next();
            Iterable<?> c = Utils.toIterable(entry.getValue());
            ArrayList list = new ArrayList();
            for (Object o : c) {
                list.add(o);
            }
            map1.put((String)entry.getKey(), list);
        }
        return map1;
    }

    public static <E extends Exception> Fn<WebContext, Map<String, List<Object>>, E> inputFn() {
        return new Fn<WebContext, Map<String, List<Object>>, E>(){

            @Override
            public Map<String, List<Object>> exec(WebContext c) {
                return c.getInput();
            }
        };
    }

    public static <E extends Exception> Fn<WebContext, Map<String, Object>, E> requestFn() {
        return new Fn<WebContext, Map<String, Object>, E>(){

            @Override
            public Map<String, Object> exec(WebContext c) {
                return c.getRequest();
            }
        };
    }

    public static <E extends Exception> Fn<WebContext, ConcurrentMap<String, Object>, E> sessionFn() {
        return new Fn<WebContext, ConcurrentMap<String, Object>, E>(){

            @Override
            public ConcurrentMap<String, Object> exec(WebContext c) {
                return c.getSession();
            }
        };
    }

    public static <E extends Exception> Fn<WebContext, ConcurrentMap<String, Object>, E> applicationFn() {
        return new Fn<WebContext, ConcurrentMap<String, Object>, E>(){

            @Override
            public ConcurrentMap<String, Object> exec(WebContext c) {
                return c.getApplication();
            }
        };
    }

    public static <E extends Exception> Fn<WebContext, Object, E> containerFn() {
        return new Fn<WebContext, Object, E>(){

            @Override
            public Object exec(WebContext c) {
                return c.getContainer();
            }
        };
    }

    public static <C extends ContainerContext<WebContext>> Fn<C, Object, Exception> request(Fn<? super C, ?, ? extends Exception> fn) {
        return FactoryUtils.cache(FnUtils.join(ContainerUtils.getSubContext(), WebUtils.requestFn()), WebUtils.getKey(), fn);
    }

    public static <C extends ContainerContext<WebContext>> Fn<C, Object, Exception> session(Fn<? super C, ?, ? extends Exception> fn) {
        return FactoryUtils.concurrentCache(FnUtils.join(ContainerUtils.getSubContext(), WebUtils.sessionFn()), WebUtils.getKey(), fn);
    }

    public static <C extends ContainerContext<WebContext>> Fn<C, Object, Exception> application(Fn<? super C, ?, ? extends Exception> fn) {
        return FactoryUtils.concurrentCache(FnUtils.join(ContainerUtils.getSubContext(), WebUtils.applicationFn()), WebUtils.getKey(), fn);
    }

    public static Fn<WebContext, Void, RuntimeException> setContainerContext(Fn<? super ContainerContext<WebContext>, ?, ? extends Exception> fn) {
        return new ContainerContextSetter<RuntimeException>(fn);
    }

    public static <C extends WebContext, R, E extends Exception> Fn<C, R, E> checkTransactionToken(String key, Fn<? super C, Boolean, ? extends E> targetCheckFn, Fn<? super C, R, ? extends E> trueFn, Fn<? super C, R, ? extends E> falseFn, int size) {
        return new TransactionTokenFn<C, R, E>(key, targetCheckFn, trueFn, falseFn, size);
    }

    public static <C extends WebContext, R, E extends Exception> Fn<C, R, E> checkTransactionToken(String key, Fn<? super C, Boolean, ? extends E> targetCheckFn, Fn<? super C, R, ? extends E> trueFn, Fn<? super C, R, ? extends E> falseFn) {
        return WebUtils.checkTransactionToken(key, targetCheckFn, trueFn, falseFn, 32);
    }
}

