/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.samples.iframe;

import junit.framework.TestCase;
import woolpack.adapter.JXPUtils;
import woolpack.samples.SamplesAllTests;
import woolpack.test.TestDomContextBuilder;

public class IFrameServletTest extends TestCase {

	public void testNormal() throws Exception {
		final IFrameServlet servlet = new IFrameServlet();
		servlet.toNode.setFn(SamplesAllTests.getFileToNode("^(.*)$", "html/sample/iframe/$1.html"));
		final TestDomContextBuilder builder = new TestDomContextBuilder(JXPUtils.ONE);
		
		builder.get().setId("common_top");
		servlet.fn.exec(builder.get());
		assertTrue(builder.exists("//*[contains(text(), \'head\')]"));
		assertTrue(builder.exists("//*[contains(text(), \'menu\')]"));
		assertTrue(builder.exists("//*[contains(text(), \'top\')]"));
	}
}
