/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk;

import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.disk.PurgatoryElement;
import org.apache.jcs.engine.CacheEventQueue;
import org.apache.jcs.engine.CacheInfo;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheEventQueue;
import org.apache.jcs.engine.behavior.ICacheListener;
import org.apache.jcs.utils.locking.ReadWriteLock;
import org.apache.jcs.utils.locking.ReadWriteLockManager;

public abstract class AbstractDiskCache
implements AuxiliaryCache,
Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$AbstractDiskCache == null ? (class$org$apache$jcs$auxiliary$disk$AbstractDiskCache = AbstractDiskCache.class$("org.apache.jcs.auxiliary.disk.AbstractDiskCache")) : class$org$apache$jcs$auxiliary$disk$AbstractDiskCache));
    protected Hashtable purgatory = new Hashtable();
    protected ICacheEventQueue cacheEventQueue;
    protected ReadWriteLock lock = new ReadWriteLock();
    protected ReadWriteLockManager locker = new ReadWriteLockManager();
    protected boolean alive = false;
    protected String cacheName;
    protected int purgHits = 0;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$AbstractDiskCache;

    public AbstractDiskCache(String cacheName) {
        this.cacheName = cacheName;
        this.cacheEventQueue = new CacheEventQueue(new MyCacheListener(), CacheInfo.listenerId, cacheName);
    }

    public final void update(ICacheElement cacheElement) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Putting element in purgatory, cacheName: " + this.cacheName + ", key: " + cacheElement.getKey()));
        }
        try {
            PurgatoryElement pe = new PurgatoryElement(cacheElement);
            pe.setSpoolable(true);
            this.purgatory.put(pe.getKey(), pe);
            this.cacheEventQueue.addPutEvent(pe);
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.cacheEventQueue.destroy();
        }
    }

    public final ICacheElement get(Serializable key) {
        if (!this.alive) {
            return null;
        }
        PurgatoryElement pe = (PurgatoryElement)this.purgatory.get(key);
        if (pe != null) {
            ++this.purgHits;
            if (log.isDebugEnabled() && this.purgHits % 100 == 0) {
                log.debug((Object)("Purgatory hits = " + this.purgHits));
            }
            pe.setSpoolable(false);
            log.debug((Object)("Found element in purgatory, cacheName: " + this.cacheName + ", key: " + key));
            this.purgatory.remove(key);
            return pe.cacheElement;
        }
        try {
            return this.doGet(key);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.cacheEventQueue.destroy();
            return null;
        }
    }

    public abstract Set getGroupKeys(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(Serializable key) {
        String keyAsString = key.toString();
        this.writeLock(keyAsString);
        try {
            this.purgatory.remove(key);
            this.doRemove(key);
        }
        finally {
            this.releaseLock(keyAsString);
        }
        return false;
    }

    public final void removeAll() {
        this.purgatory = new Hashtable();
        this.doRemoveAll();
    }

    public final void dispose() {
        this.alive = false;
        this.doDispose();
        this.cacheEventQueue.destroy();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public int getStatus() {
        return this.alive ? 1 : 2;
    }

    public abstract int getSize();

    public int getCacheType() {
        return 2;
    }

    private void writeLock(String id) {
        try {
            this.locker.writeLock(id);
        }
        catch (InterruptedException e) {
            log.error((Object)"Was interrupted while acquiring read lock", (Throwable)e);
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
    }

    private void releaseLock(String id) {
        try {
            this.locker.done(id);
        }
        catch (IllegalStateException e) {
            log.warn((Object)"Problem releasing lock", (Throwable)e);
        }
    }

    protected abstract ICacheElement doGet(Serializable var1);

    protected abstract void doUpdate(ICacheElement var1);

    protected abstract boolean doRemove(Serializable var1);

    protected abstract void doRemoveAll();

    protected abstract void doDispose();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MyCacheListener
    implements ICacheListener {
        private byte listenerId = 0;

        private MyCacheListener() {
        }

        public byte getListenerId() throws IOException {
            return this.listenerId;
        }

        public void setListenerId(byte id) throws IOException {
            this.listenerId = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handlePut(ICacheElement element) throws IOException {
            if (AbstractDiskCache.this.alive) {
                if (element instanceof PurgatoryElement) {
                    PurgatoryElement pe = (PurgatoryElement)element;
                    String keyAsString = element.getKey().toString();
                    AbstractDiskCache.this.writeLock(keyAsString);
                    try {
                        if (!AbstractDiskCache.this.purgatory.contains(pe)) {
                            return;
                        }
                        element = pe.getCacheElement();
                        if (pe.isSpoolable()) {
                            AbstractDiskCache.this.doUpdate(element);
                        }
                        AbstractDiskCache.this.purgatory.remove(element.getKey());
                    }
                    finally {
                        AbstractDiskCache.this.releaseLock(keyAsString);
                    }
                } else {
                    AbstractDiskCache.this.doUpdate(element);
                }
            }
        }

        public void handleRemove(String cacheName, Serializable key) throws IOException {
            if (AbstractDiskCache.this.alive && AbstractDiskCache.this.doRemove(key)) {
                log.debug((Object)("Element removed, key: " + key));
            }
        }

        public void handleRemoveAll(String cacheName) throws IOException {
            if (AbstractDiskCache.this.alive) {
                AbstractDiskCache.this.doRemoveAll();
            }
        }

        public void handleDispose(String cacheName) throws IOException {
            if (AbstractDiskCache.this.alive) {
                AbstractDiskCache.this.doDispose();
            }
        }
    }
}

