/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.torque.adapter.DB;

public class DBOracle
extends DB {
    private static final String DATE_FORMAT = "dd-MM-yyyy HH:mm:ss";

    protected DBOracle() {
    }

    public String toUpperCase(String in) {
        return "UPPER(" + in + ")";
    }

    public String ignoreCase(String in) {
        return "UPPER(" + in + ")";
    }

    public String getDateString(Date date) {
        return "TO_DATE('" + new SimpleDateFormat(DATE_FORMAT).format(date) + "', 'DD-MM-YYYY HH24:MI:SS')";
    }

    public String getIDMethodType() {
        return "sequence";
    }

    public String getIDMethodSQL(Object sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    public void lockTable(Connection con, String table) throws SQLException {
        Statement statement = con.createStatement();
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT next_id FROM ").append(table).append(" FOR UPDATE");
        statement.executeQuery(stmt.toString());
    }

    public void unlockTable(Connection con, String table) throws SQLException {
        con.commit();
    }

    public boolean supportsNativeLimit() {
        return true;
    }

    public int getLimitStyle() {
        return 4;
    }

    public boolean escapeText() {
        return false;
    }
}

