/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.dsfactory;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.TorqueException;
import org.apache.torque.dsfactory.AbstractDataSourceFactory;
import org.apache.torque.dsfactory.DataSourceFactory;

public class JndiDataSourceFactory
extends AbstractDataSourceFactory
implements DataSourceFactory {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$torque$dsfactory$JndiDataSourceFactory == null ? (class$org$apache$torque$dsfactory$JndiDataSourceFactory = JndiDataSourceFactory.class$("org.apache.torque.dsfactory.JndiDataSourceFactory")) : class$org$apache$torque$dsfactory$JndiDataSourceFactory));
    private String path;
    private Context ctx;
    private DataSource ds = null;
    private long lastLookup = 0L;
    private long ttl = 0L;
    static /* synthetic */ Class class$org$apache$torque$dsfactory$JndiDataSourceFactory;

    public DataSource getDataSource() throws TorqueException {
        long time = System.currentTimeMillis();
        if (this.ds == null || time - this.lastLookup > this.ttl) {
            try {
                this.ds = (DataSource)this.ctx.lookup(this.path);
                this.lastLookup = time;
            }
            catch (Exception e) {
                throw new TorqueException(e);
            }
        }
        return this.ds;
    }

    public void initialize(Configuration configuration) throws TorqueException {
        super.initialize(configuration);
        this.initJNDI(configuration);
        this.initDataSource(configuration);
    }

    private void initJNDI(Configuration configuration) throws TorqueException {
        log.debug((Object)"Starting initJNDI");
        Configuration c = configuration.subset("jndi");
        if (c == null || c.isEmpty()) {
            throw new TorqueException("JndiDataSourceFactory requires a jndi path property to lookup the DataSource in JNDI.");
        }
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            Iterator i = c.getKeys();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (key.equals("path")) {
                    this.path = c.getString(key);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("JNDI path: " + this.path));
                    continue;
                }
                if (key.equals("ttl")) {
                    this.ttl = c.getLong(key, this.ttl);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Time between context lookups: " + this.ttl));
                    continue;
                }
                String value = c.getString(key);
                env.put(key, value);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Set jndi property: " + key + "=" + value));
            }
            this.ctx = new InitialContext(env);
            log.debug((Object)"Created new InitialContext");
            this.debugCtx(this.ctx);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            throw new TorqueException(e);
        }
    }

    private void initDataSource(Configuration configuration) throws TorqueException {
        log.debug((Object)"Starting initDataSource");
        try {
            Object ds = null;
            Configuration c = configuration.subset("datasource");
            if (c != null) {
                Iterator i = c.getKeys();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    if (key.equals("classname")) {
                        String classname = c.getString(key);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Datasource class: " + classname));
                        }
                        Class<?> dsClass = Class.forName(classname);
                        ds = dsClass.newInstance();
                        continue;
                    }
                    if (ds != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Setting datasource property: " + key));
                        }
                        this.setProperty(key, c, ds);
                        continue;
                    }
                    log.error((Object)("Tried to set property " + key + " without Datasource definition!"));
                }
            }
            if (ds != null) {
                this.bindDStoJndi(this.ctx, this.path, ds);
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            throw new TorqueException(e);
        }
    }

    public void close() {
    }

    private void debugCtx(Context ctx) throws NamingException {
        log.debug((Object)"InitialContext -------------------------------");
        Hashtable<?, ?> env = ctx.getEnvironment();
        Iterator qw = env.keySet().iterator();
        log.debug((Object)("Environment properties:" + env.size()));
        while (qw.hasNext()) {
            Object prop = qw.next();
            log.debug((Object)("    " + prop + ": " + env.get(prop)));
        }
        log.debug((Object)"----------------------------------------------");
    }

    private void bindDStoJndi(Context ctx, String path, Object ds) throws Exception {
        this.debugCtx(ctx);
        int start = path.indexOf(58) + 1;
        if (start > 0) {
            path = path.substring(start);
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String subctx = st.nextToken();
            if (st.hasMoreTokens()) {
                try {
                    ctx.createSubcontext(subctx);
                    log.debug((Object)("Added sub context: " + subctx));
                }
                catch (NameAlreadyBoundException nabe) {
                }
                catch (NamingException ne) {
                    // empty catch block
                }
                ctx = (Context)ctx.lookup(subctx);
                continue;
            }
            ctx.bind(subctx, ds);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

